// $Id: JGProcProgManager.h,v 1.2 2003/02/15 04:18:10 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGProcProgManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGPROCPROGMANAGER_H
#define JGPROCPROGMANAGER_H

#include "JGManager.h"

class JGProcProgStorage;
class BS2Item;
class BS2Atom;

//
// Process Program Verification
//
enum
{
    ACKC7_OK = 0,
    ACKC7_NOT_PERMIT = 1,   ACKC7_LENGTH_ERROR = 2, ACKC7_MATRIX_OVERFLOW = 3,
    ACKC7_INVALID_PPID = 4, ACKC7_MODE_UNSUPPORTED = 5
};

struct ProcProgVerification
{
    ProcProgVerification() : m_ack(ACKC7_OK), m_seqnum(1), m_error(_TX("")) {}
    ProcProgVerification(int ackc7, int num, const string& err)
           : m_ack(ackc7), m_seqnum(num), m_error(err) {}
    ProcProgVerification(const ProcProgVerification& rhs) { copy(rhs); }
    ~ProcProgVerification() {}

    ProcProgVerification& operator=(const ProcProgVerification& rhs) {
            if (this == &rhs)
                return *this;
            copy(rhs);
            return *this;
        }
    void copy(const ProcProgVerification& rhs) {
            m_ack = rhs.m_ack;
            m_seqnum = rhs.m_seqnum;
            m_error = rhs.m_error;
        }

    BYTE m_ack;
    int  m_seqnum;
    string m_error;
};

/*
 * Process Program Manager Class
 */
class BEE_Export JGProcProgManager: public JGManager
{
    friend class ProcProgTimerHandler;

public:
    enum { MAX_WAITING_TIME = 300 };    // second
    enum { MAX_RETRY_COUNT = 5 };       // max retry that recieve PPGNT_BUSY
    enum { SOURCE = 0, OBJECT = 1 };    // Body Format
    enum
    {                                   // Change Status
        NO_CHANGE = 0, CREATED = 1,   UPDATED = 2,
        STORED = 3,    REPLACED = 4,  DELETED = 5,
        COPIED = 6,    RENAMED = 7,   UNPROTECTED = 8,
        PROTECTED = 9, VERIFIED = 10, LINKED = 11,
        UNLINKED = 12, CERTIFIED = 13,DE_SERTIFIED = 14,
        SELECTED = 15, DESELECTED = 16, PURGED = 17
    };

public:
    JGProcProgManager();
    ~JGProcProgManager();

    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int notify(const string& catgry, JGVariable * var,
                       void * arg);
    virtual int init(void * = 0);

    vector<JGid>&  ppids() { return m_ppids; }
    int  find(JGid& ppid);          // return pp size, but -1 mean error
    int  find(const string& ppid);  // return pp size, but -1 mean error
    int  read(JGid& ppid, BYTE*& datap, size_t& size);
    int  write(JGid& ppid, BYTE * datap, size_t size);
    int  del(JGid& ppid);
    int  purge();

    // Request to host
    int  upload(JGid& ppid, int tm = MAX_WAITING_TIME, int q = MAX_RETRY_COUNT);
    int  download(JGid& ppid, int tm = MAX_WAITING_TIME);
    int  verified(JGid& ppid, vector<ProcProgVerification>& ppv);

    void dump() const;

    static JGProcProgManager * instance();

protected:
    BS2Message * inqPPLoad(BS2Message * msg);           // S7F1
    BS2Message * loadGrant(BS2Message * msg);           // S7F2
    BS2Message * downUnformatted(BS2Message * msg);     // S7F3
    BS2Message * ppAck(BS2Message * msg);               // S7F4
    BS2Message * upUnformatted(BS2Message * msg);       // S7F5
    BS2Message * ppData(BS2Message * msg);              // S7F6
    BS2Message * remove(BS2Message * msg);              // S7F17
    BS2Message * eppd(BS2Message * msg);                // S7F19
    BS2Message * upFormatted(BS2Message * msg);         // S7F25
    BS2Message * downFormatted(BS2Message * msg);       // S7F23

    int ppgnt(BS2Atom * atom);

private:
    ACE_Auto_Event m_event;
    MUTEX_Ptr      m_watchdog;
    int  m_retryTime;        // seconds when received S7F2's retry grant

    JGProcProgStorage * m_programs;
    JGVariable * m_format;               // SOURCE or OBJECT (Not used)
    JGVariable * m_changeList;
    JGVariable * m_changeName;
    JGVariable * m_changeStatus;
    JGVariable * m_ppFormat;
    vector<JGid> m_ppids;               // recent ppid list
};


#endif  /* JGPROCPROGMANAGER */
