// $Id: JGPluralSub.cpp,v 1.5 2003/02/28 14:44:50 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGPluralSub.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGPluralSub.h"
#include "JGManager.h"
#include "JGVariable.h"

extern int parseEnumNames(const string& enames, vector<string>& retvec);

//-----------------------------------------------------------------------------
//
// Plural Base
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Parse enumerate token
//-----------------------------------------------------------------------------
int JGPluralSubBase::parse()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGPluralSubBase::parse");
    int result = ::parseEnumNames(m_trgName, m_enames);
    if (result < 0)
    {
        TRACE_ERROR((_TX("Illegal enumurate tokens.\n"), m_trgName.c_str()));
    }
    return result;
}

//-----------------------------------------------------------------------------
// Copy
//-----------------------------------------------------------------------------
JGPluralSubBase& JGPluralSubBase::operator=(const JGPluralSubBase& rhs)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGPluralSubBase::operator=");
    if (this == &rhs)
        return *this;
    (JGTriggerSubject&)(*this) = rhs;
    m_enames = rhs.m_enames;
    m_relation = rhs.m_relation;
    m_entity = rhs.m_entity;
    return *this;
}

//-----------------------------------------------------------------------------
// Entity
//-----------------------------------------------------------------------------
JGTriggerInfo * JGPluralSubBase::entity()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGPluralSubBase::entity");
    if (m_entity == NULL)
    {
        JGPluralSub * sub = new JGPluralSub(this);
        m_entity = sub;
        sub->relation(m_relation);
    }
    return m_entity;
}


//-----------------------------------------------------------------------------
//
// Plural
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Initial
//-----------------------------------------------------------------------------
int JGPluralSub::init()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGPluralSub::init");
    m_var->init();
    for (size_t i = 0; i < m_members.size(); i++)
    {
        m_members[i]->init();
    }
    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Link variable data
//-----------------------------------------------------------------------------
void JGPluralSub::copyRelation()
{
    TRACE_FUNCTION(TRL_LOW, "JGPluralSub::copyRelation");
    m_var = m_relation;
    if (m_relation != NULL)
    {
        m_relation->trginfo(this);
    }
}

//-----------------------------------------------------------------------------
// Sense I/O
//-----------------------------------------------------------------------------
int JGPluralSub::sense()
{
    TRACE_FUNCTION(TRL_LOW, "JGPluralSub::sense");
    return m_relation->sense();
}


//-----------------------------------------------------------------------------
// As changed, issue trigger.
//-----------------------------------------------------------------------------
int JGPluralSub::changed()
{
    TRACE_FUNCTION(TRL_LOW, "JGPluralSub::changed");

    int pos = m_relation->curval().getInt();
    if (pos > 0)
        pos = 1;
    if (m_subject->enumerate(pos) == _TX("UNKNOWN"))
    {   // As changed to reset, ignore
        return BEE_SUCCESS;
    }

    for (size_t i = 0; i < m_members.size(); i++)
    {
        m_members[i]->getv();
        if (m_members[i]->changed())
        {
            // Event enumerate is 1.
            m_subject->manager()->notify(m_subject->enumerate(1),
                                         m_members[i],
                                         NULL);
        }
    }
    //
    // Reset trigger variable
    //

    return BEE_SUCCESS;
}

