// $Id: JGObjTraverser.cpp,v 1.2 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGObjTraverser.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGObjTraverser.h"
#include "JGSpecification.h"
#include "JGManager.h"
#include "JGClass.h"
#include "JGErrorList.h"
#include "BS2Item.h"
#include "BS2DeclAtoms.h"


//-----------------------------------------------------------------------------
// Constructor/Destoructor
//-----------------------------------------------------------------------------
JGObjTraverser::JGObjTraverser(JGManager * mngr, JGClass * klass,
                               const BCHAR * ackName, int ackType)
        : BS2Traverser(), m_manager(mngr), m_clazz(klass)
{
    m_errs.set(ackName, ackType);
    // m_env = mnger->specification();
    m_env = (JGSpecification *)ObjSpec::instance();
}

//-----------------------------------------------------------------------------
// Check and Get Object Specification
//-----------------------------------------------------------------------------
int JGObjTraverser::checkObjSpec(BS2Atom * atom)
{
    TRACE_FUNCTION(TRL_LOW, "JGObjTraverser::checkObjSpec");

    m_objspec = ((BS2Ascii *)atom)->value();
    if (m_objspec.size() > 0 && m_env->name() != m_objspec)
    {
        TRACE_ERROR(("Unexpect ObjSpec name\n"));
        m_errs.append(ERRCODE_INVALID_PARAMETER, m_objspec);
        return -1;
    }
    return 0;
}

//-----------------------------------------------------------------------------
// Parse item in message (override)
//-----------------------------------------------------------------------------
int JGObjTraverser::parseItem(BS2Item * item)
{
    TRACE_FUNCTION(TRL_LOW, "JGObjTraverser::parseItem");

    BS2Atom * atom = item->atom();
    if (item->name() ==  _TX("ATTRID"))
    {
        // TRACE_DEBUG((_TX("%s : %d\n"), atom->toString().c_str(), m_nest));

        m_setter.setID((JGid&)atom->getValue(), m_nest);
    }
    else if (item->name() == _TX("ATTRDATA"))
    {
        // TRACE_DEBUG((_TX("%s : %d\n"), atom->toString().c_str(), m_nest));

        m_setter.setData(atom->getValue(), m_nest);
    }
    else if (item->name() == _TX("OBJSPEC"))
    {
        m_object = m_env->findObject(m_objspec);
        if (m_object != NULL)
        {    // Find same object
             m_errs.append(ERRCODE_IDENTIFIER_USED);
             return -1;
        }
        else
        {   // Create new object
            m_object = m_clazz->instance();
        }
        //
        // Start to set ID and DATA in object
        //
        m_setter = m_object->start(&m_errs);
    }
    return 0;
}


//-----------------------------------------------------------------------------
// Parse list item in message (override)
//-----------------------------------------------------------------------------
int JGObjTraverser::beginList(BS2ListItem * listitem)
{
    this->BS2Traverser::beginList(listitem);
    m_setter.enterList(m_nest);
    return 0;
}

int JGObjTraverser::endList(BS2ListItem * listitem)
{
    m_setter.exitList(m_nest);
    this->BS2Traverser::endList(listitem);
    return 0;
}

