// $Id: JGLogFileManager.h,v 1.1 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGLogFileManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGLOGFILEMANAGER_H
#define JGLOGFILEMANAGER_H

#include "JGTask.h"
#include "JGFileManager.h"

class JGVariable;
class JGLogTime;

//
// Logger file
//
class JGLogFileManager : public JGFileManager, public JGTask
{
    friend class DayTimerHandler;

public:
    JGLogFileManager(const string& rootPath)
            : JGFileManager(rootPath, _TX("log")), JGTask(_TX("LOG")) {
            m_append = true;
        }
    virtual ~JGLogFileManager() {}

    int init(const BCHAR ** categories);

    // Logging
    virtual int log(const string& category, const JGLogTime& logtm,
                    const string& logstr, JGVariable * var = NULL);
    int write(const string& category, const JGLogTime& logtm,
              const string& logstr);

    static JGLogFileManager * instance();

protected:
    JGLogFileManager()
            : JGFileManager(_TX(""), _TX("log")), JGTask(_TX("LOG")) {
            m_append = true;
        }
    int update();
protected:

    // Mutex Lock

    DayTimerHandler * m_handler;
};

#endif /* JGLOGFILEMANAGER_H */
