// $Id: JGControlManager.h,v 1.5 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGControlManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGCONTROLMANAGER_H
#define JGCONTROLMANAGER_H

#include "JGManager.h"

// Trigger names
#define TRIGGER_ONLINE_REMOTE   _TX("ONLINE_REMOTE")
#define TRIGGER_ONLINE_LOCAL    _TX("ONLINE_LOCAL")
#define TRIGGER_OFFLINE         _TX("OFFLINE")
#define TRIGGER_ONLINE          _TX("ONLINE")
#define TRIGGER_S1F0            _TX("S1F0")
#define TRIGGER_S1F2            _TX("S1F2")
#define TRIGGER_S1F15           _TX("S1F15")
#define TRIGGER_S1F17           _TX("S1F17")

class JGVariable;

/*
 * Control Manager Class
 */
class BEE_Export JGControlManager : public JGManager
{
    friend class JGControlState;

public:
    JGControlManager();
    virtual ~JGControlManager() {}

    virtual int init(void * = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int notify(const string& category, JGVariable * var,
                       void * arg = NULL);

    int  state();                          // code is defined in semidef.h
    int  change(int newState);             // Change Control State
    bool isOnline() {
            int curstate = this->state();
            return (curstate == CONTROL_ONLINE_LOCAL ||
                    curstate == CONTROL_ONLINE_REMOTE);
        }

    int sendS1F1();
    int sendS6F11(const BCHAR * event);
    int updOnline(int state, BS2Message * msg);
    int updOffline(int state, BS2Message * msg);

    static JGControlManager * instance();

//
private:
    BS2Message * makeS1F2(const BS2Message * msg);
    BS2Message * makeS1F16(const BS2Message * msg, int result);
    BS2Message * makeS1F18(const BS2Message * msg, int result);
//
private:
    JGVariable * m_controlState;          // Control State
    JGVariable * m_controlSelector;       // Control Selector
    JGVariable * m_systemDefault;         // Offline State System Default
    JGVariable * m_online;                // Latest Online State
    JGVariable * m_offline;               // Latest Offline State

    JGControlState * m_stateModel;

};


#endif
