// $Id: JGConfig.h,v 1.4 2003/03/22 16:41:44 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGConfig.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGCONFIG_H
#define JGCONFIG_H

#include "JGNameInfo.h"

class JGVariable;

// Define an object to hold configure data
class JGConfig : public JGNameVarInfo
{
    friend class JGInfoManager;
public:
    JGConfig() : JGNameVarInfo(), m_value(_TX("0")), m_unit(_TX("0")),
                 m_category(_TX("")), m_sub_category(_TX("")) {}
    virtual ~JGConfig() {}

    virtual void printOn(string& buf, int mode = 0);

    const string& value()       { return m_value; }
    const string& category()    { return m_category; }
    const BCHAR * getValue()    { return m_value.c_str(); }
    const BCHAR * getCategory() { return m_category.c_str(); }

protected:
    string m_value;
    string m_unit;
    string m_category;
    string m_sub_category;

};

typedef map<string, JGConfig, str_less, allocator<JGConfig> > JGConfigTable;
typedef JGConfigTable::value_type  JGConfigPair;
typedef vector<JGConfig *> JGConfigs;
typedef list<JGConfig *>   JGConfigList;

#endif  /* JGCONFIG_H */
