// $Id: JGBitsetSub.cpp,v 1.6 2003/02/28 14:44:50 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGBitsetSub.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGBitsetSub.h"
#include "JGManager.h"
#include "JGVariable.h"

extern int parseEnumNames(const string& enames, vector<string>& retvec);

//
// JSBitsetSub
//
//-----------------------------------------------------------------------------
// Parse enumerate token
//-----------------------------------------------------------------------------
int JGBitsetSubBase::parse()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGBitsetSubBase::parse");
    int result = ::parseEnumNames(m_trgName, m_enames);
    if (result < 0)
    {
        TRACE_ERROR((_TX("Illegal enumurate tokens.\n"), m_trgName.c_str()));
    }
    return result;
}

//-----------------------------------------------------------------------------
// Copy
//-----------------------------------------------------------------------------
JGBitsetSubBase& JGBitsetSubBase::operator=(const JGBitsetSubBase& rhs)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGBitsetSubBase::operator=");
    if (this == &rhs)
        return *this;

    (JGTriggerSubject&)(*this) = rhs;
    m_enames = rhs.m_enames;
    m_entity = rhs.m_entity;
    return *this;
}

//-----------------------------------------------------------------------------
// Entity
//-----------------------------------------------------------------------------
JGTriggerInfo * JGBitsetSubBase::entity()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGBitsetSub::entity");
    if (m_entity == NULL)
    {
        JGBitsetSub * sub = new JGBitsetSub(this);
        m_entity = sub;
    }
    return (JGTriggerInfo *)m_entity;
}

//
// JSBitsetSub
//
//-----------------------------------------------------------------------------
// Initial
//-----------------------------------------------------------------------------
int JGBitsetSub::init()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGBitsetSub::init");
    int result = this->JGTriggerInfo::init();
    return result;
}

//-----------------------------------------------------------------------------
// As changed, issue trigger to manager.
//-----------------------------------------------------------------------------
int JGBitsetSub::changed(vector<JGVariable *>& vars)
{
    TRACE_FUNCTION(TRL_LOW, "JGBitsetSub::changed");

    // Compare latest and current
    for (size_t i = 0; i < vars.size(); i++)
    {
        JGVariable * var = vars[i];
        JGvalue value = var->curval();
        int pos = (value.getBool()) ? 1 : 0;
        m_subject->manager()->notify(m_subject->enumerate(pos),
                                     var, NULL);
    }

    return BEE_SUCCESS;
}

