// $Id: SACXmlParser.h,v 1.5 2003/03/22 16:41:44 fukasawa Exp $

//=============================================================================
/**
 *  @file    SACXmlParser.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef SACXMLPARSER_H
#define SACXMLPARSER_H

#include "JGXmlParser.h"
#include "JGPLCDevice.h"

//-----------------------------------------------------------------------------
// XML parser class that defines sac.
//-----------------------------------------------------------------------------
class BEE_Export SACXmlParser : public JGDomParser
{
public:
    SACXmlParser(const string& xmlFile, JGPLCManager * sacmngr)
            : JGDomParser(xmlFile), m_sac_mngr(sacmngr) {
            m_rootag = _TX("configuration");
        }
    ~SACXmlParser() {}

    virtual int init();

protected:
    SACXmlParser() : JGDomParser(_TX("")), m_sac_mngr(NULL) {
            m_rootag = _TX("configuration");
        }
    int parseDevices(DOMNode * node);
    int parseIODeviceElm(DOMNode * node, int idtype);
    int parseValueAttrElm(DOMNode * node, JGPLCDevice& iodev);

// member variables
public:
    JGPLCManager * m_sac_mngr;
    JGPLCDevice *  m_sac;
    int            m_idtype;
};

//-----------------------------------------------------------------------------
// XML element parser class that defines sac.
//-----------------------------------------------------------------------------
typedef JGXmlElementParser_T<SACXmlParser> SACXmlParserBase;

class SACElementParser: public SACXmlParserBase
{
public:
    SACElementParser(const string& name)
            : SACXmlParserBase(name) {}
    SACElementParser(const string& name, const string& parent)
            : SACXmlParserBase(name, parent) {}
    virtual ~SACElementParser() {}

    virtual int begin(JGDomParser * )        { return 0; }
    virtual int endAttribute(JGDomParser * ) { return 0; }
    virtual int end(JGDomParser * )          { return 0; }

    virtual int parseAttribute(JGDomParser * , string& , string& ) { return -1; }
    virtual int parseText(JGDomParser * , string& )  { return 0; }
    virtual int parseCData(JGDomParser * , string& ) { return 0; }
};

#endif  // SACXMLPARSER_H
