/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2000 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xerces" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache\@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation, and was
 * originally based on software copyright (c) 1999, International
 * Business Machines, Inc., http://www.ibm.com .  For more information
 * on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

//=============================================================================
/**
 *  @file    JGXmlParser.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================


#ifndef JGXMLPARSER
#define JGXMLPARSER


//-----------------------------------------------------------------------------
//  Includes for all the program files to see
//-----------------------------------------------------------------------------
#include "ecm.h"
#include <xercesc/sax2/DefaultHandler.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/TransService.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/XMLUniDefs.hpp>
#include <xercesc/sax2/SAX2XMLReader.hpp>
#include <xercesc/sax2/XMLReaderFactory.hpp>
#include <xercesc/dom/DOMException.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/dom/DOM.hpp>
#if _XERCES_VERSION >= 20200              // version-2.2.0 support namespace
using namespace XERCES_CPP_NAMESPACE;
#endif

typedef XercesDOMParser  DOMParser;
typedef DOMNode          IDOM_Node;
typedef DOMNamedNodeMap  IDOM_NamedNodeMap;

class JGXmlElementParser;
typedef map<string, JGXmlElementParser *, str_less,
            allocator<JGXmlElementParser *> >         JGXmlElementMap;
typedef JGXmlElementMap::value_type                   JGXmlElementPair;

//-----------------------------------------------------------------------------
//  SAX Handling wrapper
//-----------------------------------------------------------------------------
class BEE_Export JGSaxHandler : public DefaultHandler
{
public:
    JGSaxHandler(const string& fileName)
            : DefaultHandler(), m_xmlName(fileName) {}
    virtual ~JGSaxHandler() {}

    virtual int init() = 0;

    const string& xmlName()               { return m_xmlName; }
    void  xmlName(const string& fileName) { m_xmlName = fileName; }

protected:
    string m_xmlName;
};


//-----------------------------------------------------------------------------
//  DOM Parsing wrapper
//-----------------------------------------------------------------------------
class BEE_Export JGDomParser : public XercesDOMParser
{
public:
    JGDomParser(const string& fileName)
            : XercesDOMParser(), m_xmlName(fileName) {}
    virtual ~JGDomParser() {}

    virtual int init() = 0;
    virtual int parseElements(DOMNode * rootNode);

    const string& xmlName() const         { return m_xmlName; }
    void  xmlName(const string& fileName) { m_xmlName = fileName; }
    const string& tagName() const         { return m_rootag; }
    void  tagName(const string& tagName)  { m_rootag = tagName; }

protected:
    int parseElement(JGXmlElementParser * userData, DOMNode * parent,
                     DOMNode * node);
    bool sameNodeName(DOMNode * node, const string& nodeName);
    JGXmlElementParser * find(const string& tag);
    void insert(JGXmlElementParser * elmParser);

protected:
    string          m_xmlName;
    string          m_rootag;
    JGXmlElementMap m_tagmap;
};

////////////////////////////////////////////////////////////////////////////////
//
// XML Parser
//
//-----------------------------------------------------------------------------
//  XML Element parser (abstruct)
//-----------------------------------------------------------------------------
class JGXmlElementParser
{
public:
    JGXmlElementParser(const string& name)
            : m_tagName(name), m_parentName(_TX("")) {}
    JGXmlElementParser(const string& name, const string& parent)
            : m_tagName(name), m_parentName(parent) {}
    virtual ~JGXmlElementParser() {}

    virtual int begin(JGDomParser * parser) = 0;
    virtual int endAttribute(JGDomParser * parser) = 0;
    virtual int end(JGDomParser * parser) = 0;
    virtual int parseAttribute(JGDomParser * parser, string& nameStr,
                               string& valStr) = 0;
    virtual int parseText(JGDomParser * parser, string& valStr) = 0;
    virtual int parseCData(JGDomParser * parser, string& valStr) = 0;

    string m_tagName;
    string m_parentName;
};

template<class T>
class JGXmlElementParser_T : public JGXmlElementParser
{
public:
    JGXmlElementParser_T(const string& name) : JGXmlElementParser(name) {}
    JGXmlElementParser_T(const string& name, const string& parent) :
        JGXmlElementParser(name, parent) {}

    T *    m_userData;
};

//-----------------------------------------------------------------------------
//  XML Parser manager in process
//-----------------------------------------------------------------------------
class BEE_Export JGXmlParser
{
public:
    JGXmlParser() {}
    ~JGXmlParser() {}

    int init(int argc, char * argv[]);
    int parseSax(JGSaxHandler& saxHandler, const string& xmlFile);
    int parseDom(JGDomParser& parser, const string& xmlFile);
    int fini();

};

//-----------------------------------------------------------------------------
//  conversion class for Xerces string to Standard
//-----------------------------------------------------------------------------
#ifndef DEFINED_STRX
#define DEFINED_STRX

class StrX
{
public :
    // -----------------------------------------------------------------------
    //  Constructors and Destructor
    // -----------------------------------------------------------------------
    StrX(const XMLCh* const toTranscode)
    {
        // Call the private transcoding method
        fLocalForm = XMLString::transcode(toTranscode);
    }

    ~StrX()
    {
        delete [] fLocalForm;
    }


    // -----------------------------------------------------------------------
    //  Getter methods
    // -----------------------------------------------------------------------
    const char* localForm() const
    {
        return fLocalForm;
    }

private :
    // -----------------------------------------------------------------------
    //  Private data members
    //
    //  fLocalForm
    //      This is the local code page form of the string.
    // -----------------------------------------------------------------------
    char*   fLocalForm;
};

inline ostream& operator<<(ostream& target, const StrX& toDump)
{
    target << toDump.localForm();
    return target;
}

inline bool operator==(const char * s, const StrX& token)
{
    return (strcmp(token.localForm(), s) == 0);
}

inline bool operator!=(const char * s, const StrX& token)
{
    return (strcmp(token.localForm(), s) != 0);
}

#endif /* DEFINED_STRX */

#endif  /* JGXMLPARSER */
