// $Id: JGPLCManager.h,v 1.4 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGPLCManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGPLCMANAGER_H
#define JGPLCMANAGER_H

#include "JGPLCDevice.h"

class PLCDeviceManager;
class JGEquipmentModule;


/*
 * I/O device manager class
 */
class BEE_Export JGPLCManager
{
public:
    JGPLCManager()
#ifdef _DEBUG
            : m_dllname(_TX("melshm_d")),
#else
            : m_dllname(_TX("melsec")),
#endif
              m_devxml(_TX("melsec.xml")), m_sacxml(_TX("sac")) {}
    JGPLCManager(string& dllname, string& devConf, string& sac)
            : m_dllname(dllname), m_devxml(devConf), m_sacxml(sac) {}
    virtual ~JGPLCManager();

    virtual int init(JGEquipmentModule& equipment);

    JGPLCDeviceTable& devices() { return m_devs; }
    PLCDeviceManager * rawio() { return m_plcmngr; }
    int add(JGPLCDevice& iodev);
    JGPLCDevice * find(JGid& devid);
    JGPLCDevice * findByName(const string& devname);
    JGPLCDevice * findByName(const BCHAR * devname) {
            string ioname(devname); return findByName(ioname);
        }

//
private:
    int linkPLCDriver();
//
private:
    string  m_dllname;
    string  m_devxml;
    string  m_sacxml;
    ACE_DLL m_dll;
    PLCDeviceManager * m_plcmngr;

    JGPLCDeviceTable m_devs;
    JGPLCDeviceMap   m_devmap;
};

#endif
