// $Id: JGFile.h,v 1.3 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGFile.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGFILE_H
#define JGFILE_H

#include "ace/FILE_IO.h"

// prototype
class JGFile;
typedef map<string, JGFile *, str_less, allocator<JGFile *> >
        JGFileMap;
typedef JGFileMap::value_type  JGFilePair;

//-----------------------------------------------------------------------------
// File Wrapper Class
//-----------------------------------------------------------------------------
class BEE_Export JGFile
{
public:
    JGFile(const string& filename) : m_opened(false), m_fileName(filename) {}
    JGFile(const string& dir, const string& filename, const string& ext);
    ~JGFile() {
            if (m_opened)
                m_file.close();
        }

    // Create the file.
    int open(int mode = 0);

    // Close the file.
    void close() { m_file.close(); m_opened = false; }

    // Close the file.
    void remove() { m_file.remove(); m_opened = false; }

    // Write data to file
    int write(const string& text);
    int write(const BYTE * buf, size_t size);

    // Read data from file
    int read(BYTE * buf, size_t size);

    // Get size
    size_t size();

    static void makeFileName(const string& dir, const string& fname,
                             const string& ext, string& path);

protected:
    JGFile() : m_opened(false), m_fileName(_TX("")) {}

// member variables
protected:
    bool        m_opened;
    ACE_FILE_IO m_file;
    string      m_fileName;
};


#endif /* JGFILE_H */
