// $Id: JGEquipmentModule.cpp,v 1.4 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGEquipmentModule.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipmentModule.h"
#include "ace/Get_Opt.h"

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
JGEquipmentModule::JGEquipmentModule()
{
    TRACE_FUNCTION(TRL_LOW, "JGEquipmentModule::JGEquipmentModule");

    m_rootPath = DIR_SEPARATOR_STRING;
    m_rootPath += _TX("jyugem");
    m_dsn = _TX("UID=jyugem;PWD=jyugem;DSN=MySQL;");
#ifdef _DEBUG
    m_plcName = _TX("melshm_d");
#else
    m_plcName = _TX("melsec");
#endif

    return ;
}

//-----------------------------------------------------------------------------
// Return own.
//-----------------------------------------------------------------------------
// Parse the command-line arguments and set options.
int JGEquipmentModule::parseArgs (int argc, char ** argv)
{
    ACE_Get_Opt getOpt(argc, argv, "dp:n:r:");
    int c;

    while ((c = getOpt()) != -1)
    {
        switch (c)
        {
        case 'd':
            m_debug = true;
            break;
        case 'p':
            m_plcName = getOpt.opt_arg();
            break;
        case 'n':
            m_dsn = getOpt.opt_arg();
            break;
        case 'r':
            m_rootPath = getOpt.opt_arg();
            break;
        default:
            ACE_ERROR((LM_ERROR, "Usage:\n"
                                 "-d debug(not support)\n"
                                 "-n <dataset and password>\n"
                                 "-r <root pathname>\n"
                                 "-p <plc's dll name>\n"));
            return -1;
            break;
        }
    }
    return 0;
}

//-----------------------------------------------------------------------------
// Initialize
//-----------------------------------------------------------------------------
int JGEquipmentModule::init(int argc, char ** argv)
{
    TRACE_FUNCTION(TRL_LOW, "JGEquipmentModule::init");

    int result = this->parseArgs(argc, argv);
    if (result < 0)
    {
        return result;
    }

    BCHAR ch = m_rootPath.at(m_rootPath.size() - 1);
    if (ch != DIR_SEPARATOR_CHAR && ch != ':')
    {
        m_rootPath += DIR_SEPARATOR_CHAR;
    }

    char * dummyArgv[] = { "JGEquipmentModule::init", "dummy", NULL };
    result = m_xmlParser.init(2, dummyArgv);
    if (result < 0)
    {
        return result;
    }
    result = m_iodevs.init(*this);
    if (result < 0)
    {
        return result;
    }

    return result;
}

//-----------------------------------------------------------------------------
// Finish
//-----------------------------------------------------------------------------
int JGEquipmentModule::fini(long param)
{
    TRACE_FUNCTION(TRL_LOW, "JGEquipmentModule::fini");
    ACE_UNUSED_ARG(param);

    int result = m_xmlParser.fini();
    return result;
}
