// $Id: JGDevObject.h,v 1.3 2003/02/02 15:56:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGDevObject.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGDEVOBJECT_H
#define JGDEVOBJECT_H

#include "ecm.h"
#include "JGLogTime.h"

//
// I/O Device Object
//
class BEE_Export JGDevObject : public b_object
{
    friend class  JGDevType;

public:
    ~JGDevObject() {}
    JGDevObject& operator=(const JGDevObject& rhs);

    int    read(JGLogTime * timestamp = NULL);  // Read attrdata from plc
    string toXml();
    string toString();
    void   set(const JGLogTime& time) { m_logtime = time; }
    bool   equal(const JGDevObject& rhs);
    void   dump() const;
//
private:
    JGDevObject(JGDevType * objtype, ULONG id);
    JGDevObject(const JGDevObject& rhs);
    void copy(const JGDevObject& rhs);

//
protected:
    ULONG   m_seqid;
    JGLogTime m_logtime;
};


#endif  /* JGDEVOBJECT_H */
