// $Id: JGDataBase.cpp,v 1.5 2003/03/16 14:51:00 fukasawa Exp $

// $Id: JGDataBase.cpp,v 1.5 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGDataBase.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGDataBase.h"

// static const BCHAR * DSN_ACCESS = _TX("Driver={Microsoft Access Driver (*.mdb)};DBQ=%s;");
static const BCHAR * DSN_MYSQL  = _TX("UID=jyugem;PWD=jyugem;DSN=MySQL;");

static JGDataBase * _manager = NULL;
#ifdef WIN32
static BCHAR * _root = (_TX("\\jyugem\\data"));
#else
static BCHAR * _root = (_TX("/jyugem/data"));
#endif

static MUTEX_Bool _connected(false);

//-----------------------------------------------------------------------------
// ODBC Connect/Release
//-----------------------------------------------------------------------------
int JGDataBase::connect(const string& mdb)
{
    BCHAR dsn[512];
    BCHAR path[256];
    string dsnStr;

    ACE_DEBUG((LM_DEBUG, ACE_TEXT("%T Connect database = %s\n"), mdb.c_str()));
    _stprintf(path, _TX("%s%c%s"), _root, DIR_SEPARATOR_CHAR, mdb.c_str());
    _stprintf(dsn, DSN_MYSQL, path);
    dsnStr = dsn;
    try
    {
        DBConnection::GetDefaultConnection().Connect(dsnStr);
    }
    catch (dtl::RootException &ex)
    {
        JGDataBase::errdb(_TX("JGDataBase::connect"), mdb, ex);
        return BEE_ERROR;
    }
    _connected = true;
    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
int JGDataBase::release()
{
    DBConnection::GetDefaultConnection().Release();
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("%T Release database\n")));
    _connected = false;
    return 0;
}

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
JGDataBase::JGDataBase(const BCHAR * root)
{
    m_root = (root == NULL) ? _root : root;
}

//-----------------------------------------------------------------------------
JGDataBase::~JGDataBase()
{
    if (_connected == true)
    {
        JGDataBase::release();
    }
}

//-----------------------------------------------------------------------------
// Return own.
//-----------------------------------------------------------------------------
JGDataBase * JGDataBase::instance()
{
    TRACE_FUNCTION(TRL_LOW, "JGDataBase::instance");
    if (_manager == NULL)
    {
        _manager = new JGDataBase();
    }
    return _manager;
}

//-----------------------------------------------------------------------------
// Init.
//-----------------------------------------------------------------------------
int JGDataBase::init(long param)
{
    ACE_UNUSED_ARG(param);
    return 0;
}


//-----------------------------------------------------------------------------
// Load
//-----------------------------------------------------------------------------
int JGDataBase::load()
{
    return 0;
}

//-----------------------------------------------------------------------------
// Save
//-----------------------------------------------------------------------------
int JGDataBase::save()
{
    return 0;
}


//-----------------------------------------------------------------------------
// Dump exception from database
//-----------------------------------------------------------------------------
void JGDataBase::errdb(const string& func, const string& mdb,
                       dtl::RootException& ex)
{
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("%s: mdb = %s\n"),
                         func.c_str(), mdb.c_str()));
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("type = %s, method = %s\n"),
                         ex.exType.c_str(), ex.method.c_str()));
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("error: %s\n"), ex.errmsg.c_str()));
}

