// $Id: JSListItem.h,v 1.4 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSListItem.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JSLISTITEM_H
#define JSLISTITEM_H

#include "BS2ListItem.h"
#include "JSAtom.h"

class JSListItem
{
public:
    JSListItem() {}
    ~JSListItem() {}

    void init(JNIEnv * jenv);

    bool    isList(jobject obj);
    jobject makeListObj();

    // item list to object
    int toItemObj(BS2ListItem * listItem, jobject listObj);

    // jobject to item
    int toItem(jobject listObj, BS2ListItem * listItem);

    // Global access method
    static JSListItem * instance();

protected:
    JNIEnv *  m_jenv;
    jclass    m_class;   // SECSList

    jmethodID m_new;
    jmethodID m_setList;
    jmethodID m_setItem;
    jmethodID m_addItem;
    jmethodID m_size;
    jmethodID m_at;

    jfieldID  m_userFld;
};

#endif
