// $Id: JSBoolean.cpp,v 1.5 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSBoolean.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JSBoolean.h"
#include "BS2Array.h"
#include "BS2List.h"

static const char * _className = "java/lang/Boolean";

void JSBoolean::init(JNIEnv * jenv, jclass itemClass)
{
    TRACE_FUNCTION(TRL_LOW, "JSBoolean::init");

    initClass(jenv, itemClass);

    m_class = m_jenv->FindClass(_className);
    ASSERT_JCLASS(m_class, _className);

    m_vget = m_jenv->GetMethodID(m_class, "booleanValue", "()Z");
    ASSERT_METHODID(m_vget, "booleanValue", "()Z");

    m_item = m_jenv->GetMethodID(itemClass, "<init>",
                                            "(Ljava/lang/String;Z)V");
    ASSERT_METHODID(m_item, "<init>", "(Ljava/lang/String;Z)V");
}

// secs value to atom object
jobject JSBoolean::toObj(BS2Atom * atom)
{
    TRACE_FUNCTION(TRL_LOW, "JSBoolean::toObj");
    jobject obj = m_jenv->NewObject(m_class, m_new,
                                    reinterpret_cast<BS2Boolean *>(atom)->value());
    return obj;
}

// secs value to item object
jobject JSBoolean::toItemObj(BS2Atom * atom, jstring itemName)
{
    TRACE_FUNCTION(TRL_LOW, "JSBoolean::toItemObj");

    jboolean val = reinterpret_cast<BS2Boolean *>(atom)->value() ? 1 : 0;
    return m_jenv->NewObject(m_itemClass, m_item, itemName, val);
}

// jobject to secs value
BS2Atom * JSBoolean::toAtom(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSBoolean::toAtom");

    BS2Atom * atom;
    if (valObj != NULL)
    {
        jboolean boolval = m_jenv->CallBooleanMethod(valObj, m_vget);
        atom = new BS2Boolean((boolval != 0) ? true : false);
    }
    else
    {
        atom = new BS2Boolean();
    }
    return atom;
}

// jobject to secs array
BS2Atom * JSBoolean::toArray(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSBoolean::toArray");

    if (valObj == NULL)
    {
        TRACE_ERROR(("Empty member object\n"));
        return NULL;
    }

    jobjectArray array = (jobjectArray)valObj;
    jsize len     = m_jenv->GetArrayLength(array);
    bool * values = new bool[len];
    for (int i = 0; i < len; i++)
    {
        jobject obj  = m_jenv->GetObjectArrayElement(array, i);
        jboolean val = m_jenv->CallBooleanMethod(obj, m_vget);
        *(values + i) = (bool)val;
    }
    BS2BoolArray * atom = new BS2BoolArray();
    atom->add(values, len);
    delete[] values;

    return atom;
}

// jobject to secs list
int JSBoolean::toList(jobject valObj, BS2List * listAtom)
{
    TRACE_FUNCTION(TRL_LOW, "JSBoolean::toList");

    jint len = m_jenv->CallIntMethod(valObj, m_listSize);
    for (int i = 0; i < len; i++)
    {
        jobject mbrObj = m_jenv->CallObjectMethod(valObj, m_listGet, i);
        jboolean val = m_jenv->CallBooleanMethod(mbrObj, m_vget);
        BS2Atom * atom = new BS2Boolean((val != 0) ? true : false);
        listAtom->add(*atom);
        delete atom;
    }
    return 0;
}

