/* $Id: Unicode.java,v 1.2 2004/11/27 06:51:33 fukasawa Exp $ */

/**
 *  @file    Unicode.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package com.jyugem.secs;

import java.io.UnsupportedEncodingException;
import java.*;

public final class Unicode extends Object {

    private String value;    // *** value ***

    // Constructor
    public Unicode(String s) {
        this.value = s;
    }

    public Unicode(Unicode s) {
        this.value = s.value;
    }

    public static String toString(byte[] s) throws UnsupportedEncodingException {
        String str;
        try {
           str = new String(s, "shift_jis");
        } catch (UnsupportedEncodingException e) {
            throw e;
        }
        return str;
    }

    public static Unicode valueOf(String s) {
        return new Unicode(s);
    }

    // Decodes a String into a Jis.
    public static Unicode decode(String str) {
        return Unicode.valueOf(str);
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Unicode) {
            Unicode another = (Unicode)obj;
            return (this.value == another.value);
        }
        return false;
    }

    public int compareTo(Unicode another) {
        return value.compareTo(another.value);
    }

    public int compareTo(Object obj) {
        return compareTo((Unicode)obj);
    }

}
