/* $Id: SECSResponse.java,v 1.5 2004/11/27 06:51:33 fukasawa Exp $ */

/**
 *  @file    SECSResponce.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.secs;

public class SECSResponse extends Object implements MessageMaker {
    XmlMessage m_messages;
    String m_primary;
    String m_secondary;

    SECSResponse(String secondary) {
        m_secondary = secondary;
        int num = SECSMessage.toStreamNumber(secondary);
        m_primary = SECSMessage.toStreamName(num - 1);
    }

    SECSResponse(String secondary, XmlMessage concreteMessage) {
        m_secondary = secondary;
        int num = SECSMessage.toStreamNumber(secondary);
        m_primary = SECSMessage.toStreamName(num - 1);
        m_messages = concreteMessage;
    }

    public SECSMessage make(SECSMessage primary) {
        try {
            SECSMessage reply = m_messages.makeMessage(m_secondary);
            reply.transaction(primary.transaction());
            return reply;
        } catch (SECSException e) {
            System.err.println("error: Can't make response:" + m_secondary);
            m_messages.dump();
            return null;
        }
    }

    //
    // Messages
    //
    public static class S2F18 extends SECSResponse {
        S2F18() { super("S2F18"); }

        public SECSMessage make(SECSMessage primary) {
            SECSMessage s2f18 = new SECSMessage("S2F18");
            SECSItem item = new SECSItem("TIME", SECSTime.get());
            s2f18.set(item);
            s2f18.transaction(primary.transaction());
            return s2f18;
        }
    }

}
