/* $Id: SECSDriver.java,v 1.5 2004/08/14 14:48:43 fukasawa Exp $ */

/**
 *  @file    SECSDriver.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.secs;

import java.util.*;
import java.lang.*;
import java.*;

public class SECSDriver extends Object {
    static {
        // Load the JYUSECS C++ library
        System.loadLibrary("jyusecs");
    }

    public static final int HSMS = 1;
    public static final int SECS = 0;

    boolean m_dump = true;
    int deviceID;
    int device;   // HSMS or SECS

    // Constructor
    public SECSDriver() {}

    //
    // Parameter of SECS Device
    //
    public class Parm {
        protected String  m_xml;
        protected int     m_devid;
        protected boolean m_isEquipment;

        public Parm(String xml, int dev_id, boolean equip) {
            m_xml = xml; m_devid = dev_id; m_isEquipment = equip;
        }
    }
    // for SECS-I
    public class CommParm extends Parm {
        protected int m_baudrate;
        protected int m_port;

        public CommParm(String xml, int devid, boolean equip, int baud,
                        int commnum) {
            super(xml, devid, equip);
            m_baudrate = baud;
            m_port = commnum;
        }
    }
    // for HSMS
    public class SocketParm extends Parm {
        protected String m_ip;
        protected int    m_port;
        protected int    m_mode;

        public SocketParm(String xml, int devid, boolean equip, String ipaddr,
                          int port, int mode) {
            super(xml, devid, equip);
            m_ip = ipaddr;
            m_port = port;
            m_mode = mode;  // 0 = ACTIVE, 1 = PASSIVE
        }
    }

    // Native interface
    static native int nativeOpen(Parm parm);
    static native int nativeSend(SECSMessage msg);
    static native SECSMessage nativeReceive() throws Exception;
    static native int nativeClose();

    //
    // API
    //
    public int open(String xml, int iotype) {
        SocketParm parm = new SocketParm(xml, 1, true, "127.0.0.1", 5000, 0);
        return nativeOpen(parm);
    }

    public int open(String xml, int devid, boolean equip, String ipaddr,
                    int port, int mode) {
        SocketParm parm = new SocketParm(xml, devid, equip, ipaddr, port, mode);
        return nativeOpen(parm);
    }

    public int open(String xml, int devid, boolean equip, int baud, int port) {
        CommParm parm = new CommParm(xml, devid, equip, baud, port);
        return nativeOpen(parm);
    }

    synchronized public int send(SECSMessage msg) {
        if (m_dump) {
            msg.dump();
        }
        return nativeSend(msg);
    }

    public SECSMessage receive() {
        SECSMessage msg = null;
        try {
            msg = nativeReceive();
            if (m_dump && msg != null) {
                msg.dump();
            }
        } catch (Exception e) {
            System.out.println("SECSDriver.receive(): " + e.getMessage());
            e.printStackTrace();
        }
        return msg;
    }
}

