/* $Id: TestPair.java,v 1.4 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    TestPair.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.jsunit.tfw;

import java.util.*;
import org.w3c.dom.Node;
import junit.framework.*;
import com.jyugem.secs.*;

/**
 * A Decorator for Tests. Use TestNode as the base class
 * for defining new test decorators. Test decorator subclasses
 * can be introduced to add behaviour before or after a test
 * is run.
 *
 */
public abstract class TestPair {
    public static int NOP = 0;
    public static int PASS = 1;
    public static int XPASS = 2;

    public static int SELF = 0;
    public static int RECEIVED = 1;

    public static int MATCH = 0;
    public static int CONTAIN = 1;
    public static int NOT_MATCH = 2;
    public static int NOT_CONTAIN = 3;
    SECSTestManager m_manager = null;

    ArrayList m_pairs = new ArrayList();

    public TestPair() {}

    public void init() {
        Pair pair = new Pair();
        m_pairs.add(pair);
    }

    public void setManager(SECSTestManager mngr) {
        m_manager = mngr;
    }

    public void add(String sf, Node msgNode) {
        Pair pair = new Pair(sf, msgNode);
        m_pairs.add(pair);
    }
    public void add(String msg, boolean defaultMessage) {
        Pair pair = new Pair(msg, defaultMessage);
        m_pairs.add(pair);
    }
    public void set(String sf, Node msgNode) {
        Pair pair;
        if (m_pairs.isEmpty()) {
            pair = new Pair(sf, msgNode);
            m_pairs.add(pair);
        } else {
            pair = (Pair)m_pairs.get(m_pairs.size() - 1);
            pair.m_msgStr = sf;
            pair.m_message = msgNode;
            pair.m_default = false;
        }
    }
    public void set(String msg, boolean defaultMessage) {
        Pair pair;
        if (m_pairs.isEmpty()) {
            pair = new Pair(msg, defaultMessage);
            m_pairs.add(pair);
        } else {
            pair = (Pair)m_pairs.get(m_pairs.size() - 1);
            pair.m_msgStr = msg;
            pair.m_default = defaultMessage;
            pair.m_message = null;
        }
    }
    public void setLast(String expect, int decision, int match, int pattern) {
        if (m_pairs.isEmpty()) {
            Pair pair = new Pair();
            m_pairs.add(pair);
        }
        Pair pair = (Pair)m_pairs.get(m_pairs.size() - 1);
        pair.m_expect = expect;
        pair.m_decision = decision;
        pair.m_match = match;
        pair.m_pattern = pattern;
    }

    public int size() { return m_pairs.size(); }
    public boolean isMatch()    { return (((Pair)m_pairs.get(0)).m_match == MATCH); }
    public int    getMatch()    { return ((Pair)m_pairs.get(0)).m_match; }
    public int    getDecision() { return ((Pair)m_pairs.get(0)).m_decision; }
    public String getExpect()   { return ((Pair)m_pairs.get(0)).m_expect; }
    public SECSMessage getMessage()  { return ((Pair)m_pairs.get(0)).getMessage(); }
    public boolean isMatch(int index) {
        return (((Pair)m_pairs.get(index)).m_match == MATCH);
    }
    public int getMatch(int index) {
        return ((Pair)m_pairs.get(index)).m_match;
    }
    public int getDecision(int index) {
        return ((Pair)m_pairs.get(index)).m_decision;
    }
    public SECSMessage getMessage(int index) {
        return ((Pair)m_pairs.get(index)).getMessage();
    }
    public String getExpect(int index) {
        return ((Pair)m_pairs.get(index)).m_expect;
    }

    public String toXmlString(boolean active) {
        String xml = "";
        Pair pair;
        int len = m_pairs.size();
        if (len == 1) {
            pair = (Pair)m_pairs.get(0);
            xml += pair.toXmlString(active);
        } else {
            xml += "<secs:expects>\n";
            for (int i = 0; i < len; i++) {
                pair = (Pair)m_pairs.get(i);
                xml += pair.toXmlString(active);
            }
            xml += "</secs:expects>\n";
        }
        return xml;
    }

    //
    // Pair of to send message and to expect pattern class
    //
    protected class Pair {
        protected String  m_expect = null;
        protected Node    m_message = null;
        protected String  m_msgStr = null;
        protected boolean m_default = false;
        protected int     m_decision = PASS;
        protected int     m_match = MATCH;
        protected int     m_pattern = SELF;

        public Pair() {}

        public Pair(String sf, boolean defaultMessage) {
            m_msgStr = sf;
            m_default = defaultMessage;
        }

        public Pair(String sf, Node msgNode) {
            m_msgStr = sf;
            m_message = msgNode;
        }

        int getDecision()   { return m_decision; }
        int getMatch()      { return m_match; }
        SECSMessage getMessage() {
            try {
                if (m_default) {
                    // Get message node
                    Node msgNode = (Node)m_manager.getDefaultMessages().get(m_msgStr);
                    return XmlMessage.parseMessageElementNode(msgNode);
                } else {
                    if (m_message != null) {
                        return XmlMessage.parseMessageElementNode(m_message);
                    }
                }
            } catch (SECSException e) {
            }
            return null;
        }

        String getExpect()  {
            if (m_pattern == TestPair.RECEIVED) {
                return SECSTestCase.getResentReceived();
            } else {
                return m_expect;
            }
        }

        String toXmlString(boolean active) {
            String deciStr[] = {"NOP", "PASS", "XPASS" };
            String matchStr[] = {"MATCH", "CONTAIN", "NOT-MATCH", "NOT-CONTAIN" };
            String sendStr = "";
            if (m_msgStr != null) {
                sendStr += "<secs:send sf=\"" + m_msgStr + "\" body=\"";
                sendStr += (m_default) ? "DEFAULT\">\n" : "THIS\">\n";
            }
            String expectStr = "";
            if (m_expect != null) {
                expectStr += "<secs:expect match=\"" + matchStr[m_match] + "";
                if (m_pattern == TestPair.RECEIVED) {
                    expectStr +=  "\" pattern=\"RECEIVED\">\n";
                } else {
                    expectStr += "\" pattern=\"THIS\">\n";
                    expectStr += "<![CDATE[" + m_expect + "]]>\n";
                }
                expectStr += "</secs:expect>\n";
            }

            String xml = "";
            if (active) {
                xml += sendStr;
                xml += expectStr;
            } else {
                xml += expectStr;
                xml += sendStr;
            }
            return xml;
        }
    }

}

