/* -*- C++ -*- */
// $Id: Options.h,v 1.1 2004/11/27 06:51:33 fukasawa Exp $

#ifndef OPTIONS_H
#define OPTIONS_H

#include "ace/config-all.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

class Options
{
public:
    // Singleton access point.
    static Options *instance(void);

    // Parse the command-line arguments and set the options.
    void parse_args(int argc, char * argv[]);

    // Set/get passive port number.
    void passive_port(u_short port);
    u_short passive_port(void) const;

    // Set/get active port number.
    void    active_port(u_short port);
    u_short active_port(void) const;
    const char * active_host(void) const;

    // Get device id.
    int device_id(void) const;

    // Enabled if we're in hexdump mode.
    int hexdump(void) const;

    // Enabled if we're in sml format.
    int sml(void) const;

    // Enabled if we're in debugging mode.
    int debug(void) const;

    // Enabled if we're in verbose mode.
    int verbose(void) const;

private:
    // = Ensure we're a Singleton.
    Options(void);
    ~Options(void);

    // Extra hexdump info.
    int m_hexdump;

    // Extra sml info.
    int m_sml;

    // Extra debugging info.
    int m_debugging;

    // Extra verbose messages.
    int m_verbosity;

    // Device ID that the Router is using.
    int m_devid;

    // Port that the Passive_Router is using.
    u_short m_passive_port;

    // Port that the Active_Router is using.
    u_short m_active_port;
    const char * m_active_host;

    // Static Singleton.
    static Options * _instance;

};

#endif /* OPTIONS_H */
