// $Id: Options.cpp,v 1.1 2004/11/27 06:51:33 fukasawa Exp $

#include "ace/Get_Opt.h"
#include "ace/Thread.h"
#include "ace/Log_Msg.h"
#include "ace/OS_NS_stdio.h"
#if defined (ACE_HAS_TRACE)
# include "ace/OS_NS_strings.h"
#endif /* ACE_HAS_TRACE */

#include "Options.h"

/* static */
Options * Options::_instance = 0;

Options * Options::instance(void)
{
    if (Options::_instance == 0)
    {
        Options::_instance = new Options;
    }
    return Options::_instance;
}

Options::Options(void)
    : m_hexdump(1), m_sml(0), m_debugging(0), m_verbosity(0),
      m_passive_port(5000), m_active_port(5000 + 1), m_active_host(0)
{
}

Options::~Options(void)
{
}

int Options::hexdump(void) const
{
    return this->m_hexdump;
}

int Options::sml(void) const
{
    return this->m_sml;
}

int Options::debug(void) const
{
    return this->m_debugging;
}

int Options::verbose(void) const
{
    return this->m_verbosity;
}

int Options::device_id(void) const
{
    return this->m_devid;
}

void Options::passive_port(u_short port)
{
    this->m_passive_port = port;
}

u_short Options::passive_port(void) const
{
    return this->m_passive_port;
}

void Options::active_port(u_short port)
{
    this->m_active_port = port;
}

u_short Options::active_port(void) const
{
    return this->m_active_port;
}

const char * Options::active_host(void) const
{
    return this->m_active_host;
}


void Options::parse_args(int argc, char * argv[])
{
    ACE_Get_Opt get_opt(argc, argv, "a:dh:i:np:sv");
    int c;

    while ((c = get_opt()) != EOF)
    {
        switch (c)
        {
        case 'a':            // master(active) port
            this->m_active_port = ACE_OS::atoi(get_opt.opt_arg());
            break;
        case 'h':            // master(active) host
            this->m_active_host = get_opt.opt_arg();
            break;
        case 'p':            // slave(passive) port
            this->m_passive_port = ACE_OS::atoi(get_opt.opt_arg());
            break;
        case 'i':
            this->m_devid = ACE_OS::atoi(get_opt.opt_arg());
            break;
        case 'n':
            this->m_hexdump = 0;
            break;
        case 's':
            this->m_sml = 1;
            break;
        case 'd':
            this->m_debugging = 1;
            break;
        case 'T':
#if defined (ACE_HAS_TRACE)
            if (ACE_OS::strcasecmp(get_opt.opt_arg(), "ON") == 0)
                ACE_Trace::start_tracing();
            else if (ACE_OS::strcasecmp(get_opt.opt_arg(), "OFF") == 0)
                ACE_Trace::stop_tracing();
#endif /* ACE_HAS_TRACE */
            break;
        case 'v':
            this->m_verbosity = 1;
            break;
        default:
            ::fprintf(stderr, "%s\n"
                              "\t[-a active port]\n"
                              "\t[-h active host name]\n"
                              "\t[-d] (enable debugging)\n"
                              "\t[-q max queue size]\n"
                              "\t[-p passive port]\n"
                              "\t[-n disable hexdump]\n"
                              "\t[-s sml]\n"
                              "\t[-v] (verbose) \n",
                              argv[0]);
            ::exit(1);
            /* NOTREACHED */
            break;
        }
    }
}
