// $Id: Analyzer.cpp,v 1.1 2004/11/27 06:51:33 fukasawa Exp $

//=============================================================================
/**
 *  @file    Analyzer.cpp
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "Analyzer.h"
#include "AnalyDevice.h"
#include "Options.h"
#include "c_wrapper.h"


static void fini_function();

//-----------------------------------------------------------------------------
//
// Equipment Manager
//
//-----------------------------------------------------------------------------
static Analyzer * _analyzer = NULL;
static BCHAR * _versionNum = _TX("0.0.2");

static char * _argv[3] = { "secs::analyzer", "stderr", NULL };

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
Analyzer::Analyzer() : MT_Task()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "Analyzer::Analyzer");
    ace_init(2, _argv);
}

//-----------------------------------------------------------------------------
Analyzer::~Analyzer()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "Analyzer::~Analyzer");
}

//-----------------------------------------------------------------------------
// Return own.
//-----------------------------------------------------------------------------
Analyzer * Analyzer::instance()
{
    TRACE_FUNCTION(TRL_LOW, "Analyzer::instance");
    if (_analyzer == NULL)
    {
        _analyzer = new Analyzer;
        ace_fini_handler(fini_function);
    }
    return _analyzer;
}

//-----------------------------------------------------------------------------
// Initialize
//-----------------------------------------------------------------------------
int Analyzer::init(void * parm)
{
    TRACE_FUNCTION(TRL_LOW, "Analyzer::init");

    this->init_log();
    AnalyDevice * devptr = this->initDevice();

    if (Options::instance()->sml())
    {
        devptr->setViewType(AnalyDevice::VIEW_SML);
    }
    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Initialize equipment/host device
//-----------------------------------------------------------------------------
AnalyDevice * Analyzer::initDevice()
{
    TRACE_FUNCTION(TRL_LOW, "Analyzer::initDevice");

    AnalyDevice * device = new AnalyDevice;
    // read config table
    DeviceParameter * dparm = this->getDeviceParameter();

    device->setName(_TX("SECS::Analyzer"));

    if (device->initialize(dparm) >= 0)
    {
        device->setAnalyzer(this);
        if (device->peerOpen() < 0)
        {
            TRACE_ERROR((_TX("Peer driver can not open.\n")));
        }
    }
    else
    {
        TRACE_ERROR((_TX("%s manager does not initialize device.\n"),
                     "SECS::Smiffer"));
        delete device;
        device = NULL;
    }
    delete dparm;
    m_device = device;
    return device;
}

//-----------------------------------------------------------------------------
// Get parameter of communication device
//-----------------------------------------------------------------------------
DeviceParameter * Analyzer::getDeviceParameter()
{
    TRACE_FUNCTION(TRL_LOW, "Analyzer::getDeviceParameter");
    DeviceParameter * dev_parm;
    string valStr;

    // Create for HSMS
    SocketParameter * socket_parm = new SocketParameter;
    socket_parm->m_slave = 0;
    socket_parm->m_mode = 1;
    socket_parm->m_dump = Options::instance()->hexdump();
    socket_parm->m_deviceId = Options::instance()->device_id();
    socket_parm->m_sourceId = 0;
    socket_parm->m_port = Options::instance()->passive_port();

    strncpy(socket_parm->m_hostname, Options::instance()->active_host(),
                                     sizeof(socket_parm->m_hostname) - 1);
    socket_parm->m_hostname[sizeof(socket_parm->m_hostname) - 1] = '\0';

    socket_parm->m_t3timeout = 45 * 1000;
    socket_parm->m_t5timeout = 10 * 1000;
    socket_parm->m_t6timeout = 5 * 1000;
    socket_parm->m_t7timeout = 10 * 1000;
    socket_parm->m_t8timeout = 5 * 1000;
    socket_parm->m_hbtimeout = 0;

    socket_parm->m_peer_port = Options::instance()->active_port();
    dev_parm = socket_parm;

    string pathname = _TX(".");
    pathname += DIR_SEPARATOR_STRING;
    pathname += _TX("secs.xml");
    if (pathname.size() >= sizeof(dev_parm->m_xmlname))
    {
        pathname = _TX("secs.xml");
    }
    _tcscpy(dev_parm->m_xmlname, pathname.c_str());

    return dev_parm;
}

//-----------------------------------------------------------------------------
// Open a service thread.
//-----------------------------------------------------------------------------
int Analyzer::open(void * parm)
{
    TRACE_FUNCTION(TRL_LOW, "Analyzer::open");
    ACE_UNUSED_ARG(parm);

    if (this->activate(THR_NEW_LWP | THR_DETACHED) == -1)
    {
        ACE_ERROR_RETURN((LM_ERROR, "%p\n", "spawn"), -1);
    }
    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Smaketop peocess
//-----------------------------------------------------------------------------
int Analyzer::stop(u_long parm)
{
    TRACE_FUNCTION(TRL_LOW, "Analyzer::stop");

    ACE_DEBUG((LM_DEBUG, ACE_TEXT("Stopping SECS::Analizer ......\n")));
    ace_fini();
    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
//  Initial logging data
//-----------------------------------------------------------------------------
int Analyzer::init_log(u_long parm)
{
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("***************************************\n")));
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("* secs::analyzer                      *\n")));
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("*   Copyright(C) 2004 BEE Co.,Ltd.    *\n")));
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("***************************************\n")));
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("version: %s\n\n"), _versionNum));
    return BEE_SUCCESS;
}

//------------------------------------------------------------------------------
// Start communication
//------------------------------------------------------------------------------
int Analyzer::start_comm(u_long parm)
{
    TRACE_FUNCTION(TRL_LOW, "Analyzer::start_comm");

    if (m_device == NULL)
    {
        return BEE_ERROR;
    }
    m_device->open();    // start to receive message

    this->open();        // Start service

    return BEE_SUCCESS;
}

//------------------------------------------------------------------------------
// Start communication in service
//------------------------------------------------------------------------------
int Analyzer::svc()
{
    TRACE_FUNCTION(TRL_MIDDLE, "Analyzer::svc");

    ACE_Reactor::instance()->handle_events();

    TRACE_DEBUG((_TX("Return ......\n")));

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Funish function
//-----------------------------------------------------------------------------
void fini_function()
{
    ACE_OS::sleep(1);
}

//-----------------------------------------------------------------------------
// Main
//-----------------------------------------------------------------------------
int main(int argc, char * argv[])
{
    Options::instance()->parse_args(argc, argv);

    Analyzer * sniffer = Analyzer::instance();
    sniffer->init();
    sniffer->start_comm();

    ace_run_loop();

    return 0;
}
