// $Id: AnalyDevice.h,v 1.1 2004/11/27 06:51:33 fukasawa Exp $

//=============================================================================
/**
 *  @file    AnalyDevice.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef ANALYDEVICE_H
#define ANALYDEVICE_H

#include "beesecs.h"
#include "BS2Gateway.h"
#include "BS2Message.h"

class Analyzer;
class BS2TransactionManager;
class BS2MessageInfo;

//-----------------------------------------------------------------------------
//
// Watch SECS Protocol Device Module
//
//-----------------------------------------------------------------------------
class BEE_Export AnalyDevice: public BS2Gateway
{
public:
    enum { VIEW_JYUGEM = 0, VIEW_SML };

public:
    AnalyDevice();
    ~AnalyDevice();

    virtual int svc(void);

    void setAnalyzer(Analyzer * ana) { m_analyzer = ana; }
    void setViewType(int view)       { m_viewType = view; }


protected:
    int m_viewType;
    Analyzer * m_analyzer;

};

#endif
