/*
 * Decompiled with CFR 0.152.
 */
package com.sun.JTreeTable;

import com.sun.JTreeTable.FileSystemModel2;
import com.sun.JTreeTable.JTreeTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.TreePath;

public class TreeTableExample2 {
    protected static int ttCount;
    protected FileSystemModel2 model;
    protected JTreeTable treeTable;
    protected int reloadRow;
    protected TreePath reloadPath;
    protected int reloadCounter;
    protected Timer timer;
    protected JLabel statusLabel;
    protected JFrame frame;
    protected String path;

    public TreeTableExample2(String string) {
        this.path = string;
        ++ttCount;
        this.frame = this.createFrame();
        Container container = this.frame.getContentPane();
        JMenuBar jMenuBar = this.createMenuBar();
        this.model = this.createModel(string);
        this.treeTable = this.createTreeTable();
        this.statusLabel = this.createStatusLabel();
        container.add(new JScrollPane(this.treeTable));
        container.add((Component)this.statusLabel, "South");
        this.reloadRow = -1;
        this.frame.setJMenuBar(jMenuBar);
        this.frame.pack();
        this.frame.show();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTableExample2.this.reload(TreeTableExample2.this.model.getRoot());
            }
        });
    }

    protected JLabel createStatusLabel() {
        JLabel jLabel = new JLabel(" ");
        jLabel.setHorizontalAlignment(4);
        jLabel.setBorder(new BevelBorder(1));
        return jLabel;
    }

    protected JTreeTable createTreeTable() {
        JTreeTable jTreeTable = new JTreeTable(this.model);
        jTreeTable.getColumnModel().getColumn(1).setCellRenderer(new IndicatorRenderer());
        Reloader reloader = new Reloader();
        this.timer = new Timer(700, reloader);
        this.timer.setRepeats(true);
        jTreeTable.getTree().addTreeExpansionListener(reloader);
        return jTreeTable;
    }

    protected FileSystemModel2 createModel(String string) {
        return new FileSystemModel2(string);
    }

    protected JFrame createFrame() {
        JFrame jFrame = new JFrame("TreeTable II");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (--ttCount == 0) {
                    System.exit(0);
                }
            }
        });
        return jFrame;
    }

    protected JMenuBar createMenuBar() {
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(TreeTableExample2.this.path);
                jFileChooser.setFileSelectionMode(1);
                int n = jFileChooser.showOpenDialog(TreeTableExample2.this.frame);
                if (n == 0) {
                    String string = jFileChooser.getSelectedFile().getPath();
                    new TreeTableExample2(string);
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Reload");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = TreeTableExample2.this.treeTable.getTree().getSelectionPath();
                if (treePath != null) {
                    TreeTableExample2.this.model.stopLoading();
                    TreeTableExample2.this.reload(treePath.getLastPathComponent());
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Stop");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeTableExample2.this.model.stopLoading();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu2 = new JMenu("Options");
        jMenuBar.add(jMenu2);
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(lookAndFeelInfoArray[i].getName());
            jMenu2.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals(lookAndFeelInfoArray[i].getName()));
            jRadioButtonMenuItem.putClientProperty("UIKey", lookAndFeelInfoArray[i]);
            jRadioButtonMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
                    if (jRadioButtonMenuItem.isSelected()) {
                        UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)jRadioButtonMenuItem.getClientProperty("UIKey");
                        try {
                            UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                            SwingUtilities.updateComponentTreeUI(TreeTableExample2.this.frame);
                        }
                        catch (Exception exception) {
                            System.err.println("unable to set UI " + exception.getMessage());
                        }
                    }
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
        }
        return jMenuBar;
    }

    protected void reload(Object object) {
        this.model.reloadChildren(object);
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    protected void updateStatusLabel() {
        if (this.reloadPath != null) {
            this.statusLabel.setText("Reloading: " + this.model.getPath(this.reloadPath.getLastPathComponent()));
            if (this.reloadCounter % 4 < 2) {
                this.statusLabel.setForeground(Color.red);
            } else {
                this.statusLabel.setForeground(Color.blue);
            }
        } else if (!this.model.isReloading()) {
            this.statusLabel.setText("Total Size: " + NumberFormat.getInstance().format(this.model.getTotalSize(this.model.getRoot())));
            this.statusLabel.setForeground(Color.black);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                new TreeTableExample2(stringArray[i]);
            }
        } else {
            String string;
            try {
                string = System.getProperty("user.home");
                if (string != null) {
                    new TreeTableExample2(string);
                }
            }
            catch (SecurityException securityException) {
                string = null;
            }
            if (string == null) {
                System.out.println("Could not determine home directory");
            }
        }
    }

    class IndicatorRenderer
    extends DefaultTableCellRenderer {
        protected NumberFormat formatter;
        protected int lastRow;

        IndicatorRenderer() {
            this.setHorizontalAlignment(4);
            this.formatter = NumberFormat.getInstance();
        }

        public void setValue(Object object) {
            this.setText(object == null ? "---" : this.formatter.format(object));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.lastRow = n;
            return this;
        }

        public void paint(Graphics graphics) {
            if (this.lastRow == TreeTableExample2.this.reloadRow) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, n, n2);
                graphics.setColor(this.getForeground());
                int n3 = Math.min(n, n2);
                if (TreeTableExample2.this.reloadCounter < 5) {
                    graphics.fillArc((n - n3) / 2, (n2 - n3) / 2, n3, n3, 90, -(TreeTableExample2.this.reloadCounter * 90));
                } else {
                    graphics.fillArc((n - n3) / 2, (n2 - n3) / 2, n3, n3, 90, (4 - TreeTableExample2.this.reloadCounter % 4) * 90);
                }
            } else {
                super.paint(graphics);
            }
        }
    }

    class Reloader
    implements ActionListener,
    TreeExpansionListener {
        Reloader() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!TreeTableExample2.this.model.isReloading()) {
                TreeTableExample2.this.timer.stop();
                if (TreeTableExample2.this.reloadRow != -1) {
                    this.generateChangeEvent(TreeTableExample2.this.reloadRow);
                }
                TreeTableExample2.this.reloadRow = -1;
                TreeTableExample2.this.reloadPath = null;
            } else {
                TreePath treePath = TreeTableExample2.this.model.getPathLoading();
                if (treePath == null) {
                    if (TreeTableExample2.this.reloadRow != -1) {
                        this.generateChangeEvent(TreeTableExample2.this.reloadRow);
                    }
                    TreeTableExample2.this.reloadRow = -1;
                    TreeTableExample2.this.reloadPath = null;
                } else {
                    int n = TreeTableExample2.this.treeTable.getTree().getRowForPath(treePath);
                    if (treePath.equals(TreeTableExample2.this.reloadPath)) {
                        TreeTableExample2.this.reloadCounter = (TreeTableExample2.this.reloadCounter + 1) % 8;
                        if (n != TreeTableExample2.this.reloadRow) {
                            int n2 = TreeTableExample2.this.reloadRow;
                            TreeTableExample2.this.reloadRow = n;
                            this.generateChangeEvent(n2);
                        }
                        this.generateChangeEvent(TreeTableExample2.this.reloadRow);
                    } else {
                        int n3 = TreeTableExample2.this.reloadRow;
                        TreeTableExample2.this.reloadCounter = 0;
                        TreeTableExample2.this.reloadRow = n;
                        TreeTableExample2.this.reloadPath = treePath;
                        if (n3 != TreeTableExample2.this.reloadRow) {
                            this.generateChangeEvent(n3);
                        }
                        this.generateChangeEvent(TreeTableExample2.this.reloadRow);
                    }
                }
            }
            TreeTableExample2.this.updateStatusLabel();
        }

        protected void generateChangeEvent(int n) {
            if (n != -1) {
                AbstractTableModel abstractTableModel = (AbstractTableModel)TreeTableExample2.this.treeTable.getModel();
                abstractTableModel.fireTableChanged(new TableModelEvent(abstractTableModel, n, n, 1));
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.updateRow();
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.updateRow();
        }

        protected void updateRow() {
            TreeTableExample2.this.reloadPath = TreeTableExample2.this.model.getPathLoading();
            if (TreeTableExample2.this.reloadPath != null) {
                TreeTableExample2.this.reloadRow = TreeTableExample2.this.treeTable.getTree().getRowForPath(TreeTableExample2.this.reloadPath);
            }
        }
    }
}

