/*
 * Decompiled with CFR 0.152.
 */
package com.sun.JTreeTable;

import com.sun.JTreeTable.AbstractTreeTableModel;
import com.sun.JTreeTable.MergeSort;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class FileSystemModel2
extends AbstractTreeTableModel {
    protected static String[] cNames = new String[]{"Name", "Size", "Type", "Modified"};
    protected static Class[] cTypes = new Class[]{class$com$sun$JTreeTable$TreeTableModel == null ? (class$com$sun$JTreeTable$TreeTableModel = FileSystemModel2.class$("com.sun.JTreeTable.TreeTableModel")) : class$com$sun$JTreeTable$TreeTableModel, class$java$lang$Integer == null ? (class$java$lang$Integer = FileSystemModel2.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = FileSystemModel2.class$("java.lang.String")) : class$java$lang$String, class$java$util$Date == null ? (class$java$util$Date = FileSystemModel2.class$("java.util.Date")) : class$java$util$Date};
    public static final Integer ZERO = new Integer(0);
    static Stack sorters = new Stack();
    protected boolean isValid = true;
    protected FileNode reloadNode;
    int reloadCount;
    protected boolean descendLinks;
    protected static FileNode[] EMPTY_CHILDREN = new FileNode[0];
    private static MergeSort fileMS = new MergeSort(){

        public int compareElementsAt(int n, int n2) {
            return ((String)this.toSort[n]).compareTo((String)this.toSort[n2]);
        }
    };
    static /* synthetic */ Class class$com$sun$JTreeTable$TreeTableModel;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MergeSort getSizeSorter() {
        Stack stack = sorters;
        synchronized (stack) {
            if (sorters.size() == 0) {
                return new SizeSorter();
            }
            return (MergeSort)sorters.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void recycleSorter(MergeSort mergeSort) {
        Stack stack = sorters;
        synchronized (stack) {
            sorters.push(mergeSort);
        }
    }

    public FileSystemModel2() {
        this(File.separator);
    }

    public FileSystemModel2(String string) {
        super(null);
        this.root = new FileNode(new File(string));
    }

    public int getChildCount(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getChild(Object object, int n) {
        return this.getChildren(object)[n];
    }

    public boolean isLeaf(Object object) {
        return ((FileNode)object).isLeaf();
    }

    public int getColumnCount() {
        return cNames.length;
    }

    public String getColumnName(int n) {
        return cNames[n];
    }

    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    public Object getValueAt(Object object, int n) {
        FileNode fileNode = (FileNode)object;
        try {
            switch (n) {
                case 0: {
                    return fileNode.getFile().getName();
                }
                case 1: {
                    if (fileNode.isTotalSizeValid()) {
                        return new Integer((int)((FileNode)object).totalSize());
                    }
                    return null;
                }
                case 2: {
                    return fileNode.isLeaf() ? "File" : "Directory";
                }
                case 3: {
                    return fileNode.lastModified();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadChildren(Object object) {
        FileNode fileNode = (FileNode)object;
        FileSystemModel2 fileSystemModel2 = this;
        synchronized (fileSystemModel2) {
            ++this.reloadCount;
        }
        fileNode.resetSize();
        new Thread(new FileNodeLoader((FileNode)object)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoading() {
        this.isValid = false;
        FileSystemModel2 fileSystemModel2 = this;
        synchronized (fileSystemModel2) {
            while (this.reloadCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.isValid = true;
    }

    public void setDescendsLinks(boolean bl) {
        this.descendLinks = bl;
    }

    public boolean getDescendsLinks() {
        return this.descendLinks;
    }

    public String getPath(Object object) {
        return ((FileNode)object).getFile().getPath();
    }

    public long getTotalSize(Object object) {
        return ((FileNode)object).totalSize();
    }

    public boolean isReloading() {
        return this.reloadCount > 0;
    }

    public TreePath getPathLoading() {
        FileNode fileNode = this.reloadNode;
        if (fileNode != null) {
            return new TreePath(fileNode.getPath());
        }
        return null;
    }

    public Object getNodeLoading() {
        return this.reloadNode;
    }

    protected File getFile(Object object) {
        FileNode fileNode = (FileNode)object;
        return fileNode.getFile();
    }

    protected Object[] getChildren(Object object) {
        FileNode fileNode = (FileNode)object;
        return fileNode.getChildren();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SizeSorter
    extends MergeSort {
        SizeSorter() {
        }

        public int compareElementsAt(int n, int n2) {
            long l;
            long l2 = ((FileNode)this.toSort[n]).totalSize();
            if (l2 != (l = ((FileNode)this.toSort[n2]).totalSize())) {
                return (int)(l - l2);
            }
            return ((FileNode)this.toSort[n]).toString().compareTo(((FileNode)this.toSort[n2]).toString());
        }
    }

    class FileNodeLoader
    implements Runnable {
        FileNode node;
        MergeSort sizeMS;

        FileNodeLoader(FileNode fileNode) {
            this.node = fileNode;
            fileNode.resetLastModified();
            fileNode.setChildren(fileNode.createChildren(fileMS), true);
            fileNode.setTotalSizeValid(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FileNode[] fileNodeArray = this.node.getChildren();
            this.sizeMS = FileSystemModel2.getSizeSorter();
            for (int i = fileNodeArray.length - 1; i >= 0; --i) {
                if (!fileNodeArray[i].isLeaf()) {
                    FileSystemModel2.this.reloadNode = fileNodeArray[i];
                    this.loadChildren(fileNodeArray[i]);
                    FileSystemModel2.this.reloadNode = null;
                }
                if (FileSystemModel2.this.isValid) continue;
                i = 0;
            }
            FileSystemModel2.recycleSorter(this.sizeMS);
            if (FileSystemModel2.this.isValid) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ FileNodeLoader this$1;
                    {
                        this.this$1 = fileNodeLoader;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        MergeSort mergeSort = FileSystemModel2.getSizeSorter();
                        mergeSort.sort(this.this$1.node.getChildren());
                        FileSystemModel2.recycleSorter(mergeSort);
                        this.this$1.node.setChildren(this.this$1.node.getChildren(), true);
                        FileSystemModel2 fileSystemModel2 = FileNodeLoader.access$100(this.this$1);
                        synchronized (fileSystemModel2) {
                            --FileNodeLoader.access$100((FileNodeLoader)this.this$1).reloadCount;
                            FileNodeLoader.access$100(this.this$1).notifyAll();
                        }
                    }
                });
            } else {
                FileSystemModel2 fileSystemModel2 = FileSystemModel2.this;
                synchronized (fileSystemModel2) {
                    --FileSystemModel2.this.reloadCount;
                    FileSystemModel2.this.notifyAll();
                }
            }
        }

        protected void loadChildren(FileNode fileNode) {
            if (!(fileNode.isLeaf() || !FileSystemModel2.this.descendLinks && fileNode.isLink())) {
                FileNode[] fileNodeArray = fileNode.createChildren(null);
                for (int i = fileNodeArray.length - 1; i >= 0; --i) {
                    if (!fileNodeArray[i].isLeaf()) {
                        if (FileSystemModel2.this.descendLinks || !fileNodeArray[i].isLink()) {
                            fileNodeArray[i].loadChildren(this.sizeMS);
                        } else {
                            fileNodeArray[i].forceTotalSizeValid();
                        }
                    }
                    if (FileSystemModel2.this.isValid) continue;
                    i = 0;
                }
                if (FileSystemModel2.this.isValid) {
                    FileNode fileNode2 = fileNode;
                    SwingUtilities.invokeLater(new Runnable(this, fileNodeArray, fileNode2){
                        private final /* synthetic */ FileNode[] val$children;
                        private final /* synthetic */ FileNode val$fn;
                        private final /* synthetic */ FileNodeLoader this$1;
                        {
                            this.this$1 = fileNodeLoader;
                            this.val$children = fileNodeArray;
                            this.val$fn = fileNode;
                        }

                        public void run() {
                            MergeSort mergeSort = FileSystemModel2.getSizeSorter();
                            mergeSort.sort(this.val$children);
                            FileSystemModel2.recycleSorter(mergeSort);
                            this.val$fn.setChildren(this.val$children, true);
                            this.val$fn.setTotalSizeValid(true);
                            this.val$fn.nodeChanged();
                        }
                    });
                }
            } else {
                fileNode.forceTotalSizeValid();
            }
        }

        static /* synthetic */ FileSystemModel2 access$100(FileNodeLoader fileNodeLoader) {
            return fileNodeLoader.FileSystemModel2.this;
        }
    }

    class FileNode {
        protected File file;
        private FileNode parent;
        protected FileNode[] children;
        protected long totalSize;
        protected boolean totalSizeValid;
        protected String canonicalPath;
        protected boolean isLink;
        protected Date lastModified;

        protected FileNode(File file) {
            this(null, file);
        }

        protected FileNode(FileNode fileNode, File file) {
            this.parent = fileNode;
            this.file = file;
            try {
                this.canonicalPath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                this.canonicalPath = "";
            }
            this.isLink = fileNode != null ? !this.canonicalPath.startsWith(fileNode.getCanonicalPath()) : false;
            if (this.isLeaf()) {
                this.totalSize = file.length();
                this.totalSizeValid = true;
            }
        }

        public Date lastModified() {
            if (this.lastModified == null && this.file != null) {
                this.lastModified = new Date(this.file.lastModified());
            }
            return this.lastModified;
        }

        public String toString() {
            return this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        public long totalSize() {
            return this.totalSize;
        }

        public FileNode getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            return this.file.isFile();
        }

        public boolean isTotalSizeValid() {
            return this.totalSizeValid;
        }

        protected void resetLastModified() {
            this.lastModified = null;
        }

        protected void resetSize() {
            this.alterTotalSize(-this.totalSize);
        }

        protected FileNode[] getChildren() {
            return this.children;
        }

        protected void loadChildren(MergeSort mergeSort) {
            this.totalSize = this.file.length();
            this.children = this.createChildren(null);
            for (int i = this.children.length - 1; i >= 0; --i) {
                Thread.yield();
                if (!(this.children[i].isLeaf() || !FileSystemModel2.this.descendLinks && this.children[i].isLink())) {
                    this.children[i].loadChildren(mergeSort);
                }
                this.totalSize += this.children[i].totalSize();
                if (FileSystemModel2.this.isValid) continue;
                i = 0;
            }
            if (FileSystemModel2.this.isValid) {
                if (mergeSort != null) {
                    mergeSort.sort(this.children);
                }
                this.totalSizeValid = true;
            }
        }

        protected FileNode[] createChildren(MergeSort mergeSort) {
            FileNode[] fileNodeArray = null;
            try {
                Object[] objectArray = this.file.list();
                if (objectArray != null) {
                    if (mergeSort != null) {
                        mergeSort.sort(objectArray);
                    }
                    fileNodeArray = new FileNode[objectArray.length];
                    String string = this.file.getPath();
                    for (int i = 0; i < objectArray.length; ++i) {
                        File file = new File(string, (String)objectArray[i]);
                        fileNodeArray[i] = new FileNode(this, file);
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (fileNodeArray == null) {
                fileNodeArray = EMPTY_CHILDREN;
            }
            return fileNodeArray;
        }

        protected boolean loadedChildren() {
            return this.file.isFile() || this.children != null;
        }

        public FileNode[] getPath() {
            return this.getPathToRoot(this, 0);
        }

        public String getCanonicalPath() {
            return this.canonicalPath;
        }

        public boolean isLink() {
            return this.isLink;
        }

        protected FileNode[] getPathToRoot(FileNode fileNode, int n) {
            FileNode[] fileNodeArray;
            if (fileNode == null) {
                if (n == 0) {
                    return null;
                }
                fileNodeArray = new FileNode[n];
            } else {
                fileNodeArray = this.getPathToRoot(fileNode.getParent(), ++n);
                fileNodeArray[fileNodeArray.length - n] = fileNode;
            }
            return fileNodeArray;
        }

        protected void setChildren(FileNode[] fileNodeArray, boolean bl) {
            long l = this.totalSize;
            this.totalSize = this.file.length();
            this.children = fileNodeArray;
            for (int i = this.children.length - 1; i >= 0; --i) {
                this.totalSize += this.children[i].totalSize();
            }
            if (bl) {
                Object[] objectArray = this.getPath();
                FileSystemModel2.this.fireTreeStructureChanged(FileSystemModel2.this, objectArray, null, null);
                FileNode fileNode = this.getParent();
                if (fileNode != null) {
                    fileNode.alterTotalSize(this.totalSize - l);
                }
            }
        }

        protected synchronized void alterTotalSize(long l) {
            if (l != 0L && (this.parent = this.getParent()) != null) {
                this.totalSize += l;
                this.nodeChanged();
                this.parent.alterTotalSize(l);
            } else {
                this.totalSize += l;
            }
        }

        protected synchronized void setTotalSizeValid(boolean bl) {
            if (this.totalSizeValid != bl) {
                this.nodeChanged();
                this.totalSizeValid = bl;
                FileNode fileNode = this.getParent();
                if (fileNode != null) {
                    fileNode.childTotalSizeChanged(this);
                }
            }
        }

        protected synchronized void forceTotalSizeValid() {
            this.totalSizeValid = true;
        }

        protected synchronized void childTotalSizeChanged(FileNode fileNode) {
            if (this.totalSizeValid != fileNode.isTotalSizeValid()) {
                if (this.totalSizeValid) {
                    this.setTotalSizeValid(false);
                } else {
                    FileNode[] fileNodeArray = this.getChildren();
                    for (int i = fileNodeArray.length - 1; i >= 0; --i) {
                        if (fileNodeArray[i].isTotalSizeValid()) continue;
                        return;
                    }
                    this.setTotalSizeValid(true);
                }
            }
        }

        protected void nodeChanged() {
            FileNode fileNode = this.getParent();
            if (fileNode != null) {
                Object[] objectArray = fileNode.getPath();
                int[] nArray = new int[]{FileSystemModel2.this.getIndexOfChild(fileNode, this)};
                Object[] objectArray2 = new Object[]{this};
                FileSystemModel2.this.fireTreeNodesChanged(FileSystemModel2.this, objectArray, nArray, objectArray2);
            }
        }
    }
}

