/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.secs;

public final class UShort
extends Number
implements Comparable {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 65535;
    private int value;

    public UShort(UShort uShort) {
        this.value = uShort.value;
    }

    public UShort(int n) {
        this.value = n;
    }

    public UShort(String string) throws NumberFormatException {
        this.value = UShort.parseUShort(string);
    }

    public static String toString(int n) {
        return Integer.toString(n);
    }

    public static int parseUShort(String string) throws NumberFormatException {
        return UShort.parseUShort(string, 16);
    }

    public static int parseUShort(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < 0 || n2 > 65535) {
            throw new NumberFormatException();
        }
        return n2;
    }

    public static UShort valueOf(String string, int n) throws NumberFormatException {
        return new UShort(UShort.parseUShort(string, n));
    }

    public static UShort valueOf(String string) throws NumberFormatException {
        return UShort.valueOf(string, 10);
    }

    public static UShort decode(String string) throws NumberFormatException {
        UShort uShort;
        int n = 10;
        int n2 = 0;
        boolean bl = false;
        if (string.startsWith("-")) {
            bl = true;
            ++n2;
        }
        if (string.startsWith("0x", n2) || string.startsWith("0X", n2)) {
            n2 += 2;
            n = 16;
        } else if (string.startsWith("#", n2)) {
            ++n2;
            n = 16;
        } else if (string.startsWith("0", n2) && string.length() > n2 + 1) {
            ++n2;
            n = 8;
        }
        if (string.startsWith("-", n2)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            uShort = UShort.valueOf(string.substring(n2), n);
            uShort = bl ? new UShort(-uShort.intValue()) : uShort;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = "";
            if (bl) {
                string2 = "-";
            }
            string2 = string2 + string.substring(n2);
            uShort = UShort.valueOf(string2, n);
        }
        return uShort;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value, 10);
    }

    public boolean equals(Object object) {
        if (object instanceof UShort) {
            return this.value == ((UShort)object).intValue();
        }
        return false;
    }

    public int compareTo(UShort uShort) {
        return this.value - uShort.value;
    }

    public int compareTo(Object object) {
        return this.compareTo((UShort)object);
    }
}

