/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.secs;

import com.jyugem.secs.MessageBox;
import com.jyugem.secs.SECSConfigurator;
import com.jyugem.secs.SECSDriver;
import com.jyugem.secs.SECSException;
import com.jyugem.secs.SECSMessage;
import com.jyugem.secs.SECSResponder;
import com.jyugem.secs.XmlMessage;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SECSManager
extends Thread {
    static SECSManager m_instance = null;
    SECSConfigurator m_configure;
    SECSResponder m_responder;
    SECSDriver m_driver;
    XmlMessage m_default;
    MessageBox m_msgbox = new MessageBox();

    public static SECSManager getInstance() {
        if (m_instance == null) {
            try {
                m_instance = new SECSManager();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            m_instance.open();
        }
        return m_instance;
    }

    protected SECSManager() {
        this.m_default = new XmlMessage();
        this.m_configure = new SECSConfigurator();
        this.m_driver = new SECSDriver();
    }

    protected int open() {
        this.m_configure.configure();
        this.m_default.open(this.m_configure.getMessageFile());
        if (this.m_configure.isHSMS()) {
            this.m_driver.open(this.m_configure.getSecsXmlFile(), this.m_configure.getDeviceID(), this.m_configure.isEquipment(), this.m_configure.getIPAddress(), this.m_configure.getPort(), this.m_configure.getMode());
        } else {
            this.m_driver.open(this.m_configure.getSecsXmlFile(), this.m_configure.getDeviceID(), this.m_configure.isEquipment(), this.m_configure.getBaudrate(), this.m_configure.getPort());
        }
        this.m_responder = new SECSResponder(this);
        this.m_responder.start();
        return 0;
    }

    public SECSDriver driver() {
        return this.m_driver;
    }

    public SECSResponder responder() {
        return this.m_responder;
    }

    public MessageBox messageBox() {
        return this.m_msgbox;
    }

    public XmlMessage getDefaultMessages() {
        return this.m_default;
    }

    public DefaultListModel getSFList() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        Iterator iterator = this.m_default.values().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("name");
            if (node2 == null) {
                node2 = namedNodeMap.getNamedItem("sf");
            }
            String string = node2.getNodeValue();
            defaultListModel.addElement(string);
        }
        return defaultListModel;
    }

    public int send(SECSMessage sECSMessage) {
        return this.m_driver.send(sECSMessage);
    }

    public int send(String string) {
        try {
            SECSMessage sECSMessage = this.m_default.makeMessage(string);
            if (sECSMessage == null) {
                return -1;
            }
            return this.m_driver.send(sECSMessage);
        }
        catch (SECSException sECSException) {
            return -1;
        }
    }

    public SECSMessage receive() {
        return this.m_driver.receive();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    SECSManager.sleep((int)(Math.random() % 100.0 * 100.0));
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) {
        SECSManager sECSManager = SECSManager.getInstance();
        sECSManager.start();
    }
}

