/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.secs;

import com.jyugem.secs.Int1;
import com.jyugem.secs.Jis;
import com.jyugem.secs.SECSException;
import com.jyugem.secs.SECSItem;
import com.jyugem.secs.SECSList;
import com.jyugem.secs.UInt1;
import com.jyugem.secs.UInteger;
import com.jyugem.secs.ULong;
import com.jyugem.secs.UShort;
import com.jyugem.secs.Unicode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class SECS {
    public static final int LIST = 0;
    public static final int BINARY = 8;
    public static final int BOOLEAN = 9;
    public static final int ASCII = 16;
    public static final int JIS = 17;
    public static final int UNICODE = 18;
    public static final int INT1 = 25;
    public static final int INT2 = 26;
    public static final int INT4 = 28;
    public static final int INT8 = 24;
    public static final int UINT1 = 41;
    public static final int UINT2 = 42;
    public static final int UINT4 = 44;
    public static final int UINT8 = 40;
    public static final int FLOAT8 = 32;
    public static final int FLOAT4 = 36;
    public static final int ARRAY = 64;
    static String[] hexTable = new String[]{"0x00", "0x01", "0x02", "0x03", "0x04", "0x05", "0x06", "0x07", "0x08", "0x09", "0x0A", "0x0B", "0x0C", "0x0D", "0x0E", "0x0F", "0x10", "0x11", "0x12", "0x13", "0x14", "0x15", "0x16", "0x17", "0x18", "0x19", "0x1A", "0x1B", "0x1C", "0x1D", "0x1E", "0x1F", "0x20", "0x21", "0x22", "0x23", "0x24", "0x25", "0x26", "0x27", "0x28", "0x29", "0x2A", "0x2B", "0x2C", "0x2D", "0x2E", "0x2F", "0x30", "0x31", "0x32", "0x33", "0x34", "0x35", "0x36", "0x37", "0x38", "0x39", "0x3A", "0x3B", "0x3C", "0x3D", "0x3E", "0x3F", "0x40", "0x41", "0x42", "0x43", "0x44", "0x45", "0x46", "0x47", "0x48", "0x49", "0x4A", "0x4B", "0x4C", "0x4D", "0x4E", "0x4F", "0x50", "0x51", "0x52", "0x53", "0x54", "0x55", "0x56", "0x57", "0x58", "0x59", "0x5A", "0x5B", "0x5C", "0x5D", "0x5E", "0x5F", "0x60", "0x61", "0x62", "0x63", "0x64", "0x65", "0x66", "0x67", "0x68", "0x69", "0x6A", "0x6B", "0x6C", "0x6D", "0x6E", "0x6F", "0x70", "0x71", "0x72", "0x73", "0x74", "0x75", "0x76", "0x77", "0x78", "0x79", "0x7A", "0x7B", "0x7C", "0x7D", "0x7E", "0x7F", "0x80", "0x81", "0x82", "0x83", "0x84", "0x85", "0x86", "0x87", "0x88", "0x89", "0x8A", "0x8B", "0x8C", "0x8D", "0x8E", "0x8F", "0x90", "0x91", "0x92", "0x93", "0x94", "0x95", "0x96", "0x97", "0x98", "0x99", "0x9A", "0x9B", "0x9C", "0x9D", "0x9E", "0x9F", "0xA0", "0xA1", "0xA2", "0xA3", "0xA4", "0xA5", "0xA6", "0xA7", "0xA8", "0xA9", "0xAA", "0xAB", "0xAC", "0xAD", "0xAE", "0xAF", "0xB0", "0xB1", "0xB2", "0xB3", "0xB4", "0xB5", "0xB6", "0xB7", "0xB8", "0xB9", "0xBA", "0xBB", "0xBC", "0xBD", "0xBE", "0xBF", "0xC0", "0xC1", "0xC2", "0xC3", "0xC4", "0xC5", "0xC6", "0xC7", "0xC8", "0xC9", "0xCA", "0xCB", "0xCC", "0xCD", "0xCE", "0xCF", "0xD0", "0xD1", "0xD2", "0xD3", "0xD4", "0xD5", "0xD6", "0xD7", "0xD8", "0xD9", "0xDA", "0xDB", "0xDC", "0xDD", "0xDE", "0xDF", "0xE0", "0xE1", "0xE2", "0xE3", "0xE4", "0xE5", "0xE6", "0xE7", "0xE8", "0xE9", "0xEA", "0xEB", "0xEC", "0xED", "0xEE", "0xEF", "0xF0", "0xF1", "0xF2", "0xF3", "0xF4", "0xF5", "0xF6", "0xF7", "0xF8", "0xF9", "0xFA", "0xFB", "0xFC", "0xFD", "0xFE", "0xFF"};

    public static String toString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "list";
                break;
            }
            case 16: {
                string = "ascii";
                break;
            }
            case 17: {
                string = "jis";
                break;
            }
            case 18: {
                string = "utf-8";
                break;
            }
            case 8: {
                string = "binary";
                break;
            }
            case 9: {
                string = "bool";
                break;
            }
            case 25: {
                string = "int1";
                break;
            }
            case 26: {
                string = "int2";
                break;
            }
            case 28: {
                string = "int4";
                break;
            }
            case 24: {
                string = "int8";
                break;
            }
            case 36: {
                string = "float4";
                break;
            }
            case 32: {
                string = "float8";
                break;
            }
            case 41: {
                string = "uint1";
                break;
            }
            case 42: {
                string = "uint2";
                break;
            }
            case 44: {
                string = "uint4";
                break;
            }
            case 40: {
                string = "uint8";
                break;
            }
            case 89: {
                string = "int1[]";
                break;
            }
            case 90: {
                string = "int2[]";
                break;
            }
            case 92: {
                string = "int4[]";
                break;
            }
            case 88: {
                string = "int8[]";
                break;
            }
            case 100: {
                string = "float4[]";
                break;
            }
            case 96: {
                string = "float8[]";
                break;
            }
            case 105: {
                string = "uint1[]";
                break;
            }
            case 106: {
                string = "uint2[]";
                break;
            }
            case 108: {
                string = "uint4[]";
                break;
            }
            case 104: {
                string = "uint8[]";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public static int toFormat(Object object) throws SECSException {
        int n;
        int n2 = n = object.getClass().isArray() ? 64 : 0;
        if (object instanceof SECSList) {
            n |= 0;
        } else if (object instanceof SECSItem) {
            SECSItem sECSItem = (SECSItem)object;
            n |= sECSItem.type();
        } else if (object instanceof String) {
            n |= 0x10;
        } else if (object instanceof Byte) {
            n |= 8;
        } else if (object instanceof Boolean) {
            n |= 9;
        } else if (object instanceof Int1) {
            n |= 0x19;
        } else if (object instanceof Short) {
            n |= 0x1A;
        } else if (object instanceof Integer) {
            n |= 0x1C;
        } else if (object instanceof Long) {
            n |= 0x18;
        } else if (object instanceof Float) {
            n |= 0x24;
        } else if (object instanceof Double) {
            n |= 0x20;
        } else if (object instanceof UInt1) {
            n |= 0x29;
        } else if (object instanceof UShort) {
            n |= 0x2A;
        } else if (object instanceof UInteger) {
            n |= 0x2C;
        } else if (object instanceof ULong) {
            n |= 0x28;
        } else if (object instanceof Jis) {
            n |= 0x11;
        } else if (object instanceof Unicode) {
            n |= 0x12;
        } else {
            String string = "Unknown value type " + object.getClass().toString();
            throw new SECSException(string);
        }
        return n;
    }

    public static int toFormat(String string) throws SECSException {
        String string2 = string.toLowerCase();
        if (string2.equals("list")) {
            return 0;
        }
        if (string2.equals("ascii")) {
            return 16;
        }
        if (string2.equals("int4")) {
            return 28;
        }
        if (string2.equals("uint4")) {
            return 44;
        }
        if (string2.equals("int2")) {
            return 26;
        }
        if (string2.equals("uint2")) {
            return 42;
        }
        if (string2.equals("binary")) {
            return 8;
        }
        if (string2.equals("boolean")) {
            return 9;
        }
        if (string2.equals("int8")) {
            return 24;
        }
        if (string2.equals("int1")) {
            return 25;
        }
        if (string2.equals("float8")) {
            return 32;
        }
        if (string2.equals("float4")) {
            return 36;
        }
        if (string2.equals("uint8")) {
            return 40;
        }
        if (string2.equals("uint1")) {
            return 41;
        }
        if (string2.equals("jis")) {
            return 17;
        }
        if (string2.equals("utf-8")) {
            return 18;
        }
        if (string2.equals("int1[]")) {
            return 89;
        }
        if (string2.equals("int2[]")) {
            return 90;
        }
        if (string2.equals("int4[]")) {
            return 92;
        }
        if (string2.equals("int8[]")) {
            return 88;
        }
        if (string2.equals("uint1[]")) {
            return 105;
        }
        if (string2.equals("uint2[]")) {
            return 106;
        }
        if (string2.equals("uint4[]")) {
            return 108;
        }
        if (string2.equals("uint8[]")) {
            return 104;
        }
        if (string2.equals("float4[]")) {
            return 100;
        }
        if (string2.equals("float8[]")) {
            return 96;
        }
        String string3 = "Unknown value type (" + string + ")";
        throw new SECSException(string3);
    }

    public static Object parseValueOf(int n, String string) throws SECSException {
        Number[] numberArray;
        block30: {
            ArrayList<Object> arrayList;
            block29: {
                Byte[] byteArray;
                int n2 = n & 0x3F;
                numberArray = null;
                arrayList = new ArrayList<Object>();
                try {
                    Object object;
                    if (n == 8 || n > 64) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        while (stringTokenizer.hasMoreTokens()) {
                            byteArray = stringTokenizer.nextToken();
                            object = SECS.convertValueOf(n2, (String)byteArray);
                            arrayList.add(object);
                        }
                    } else {
                        object = SECS.convertValueOf(n2, string);
                        arrayList.add(object);
                    }
                }
                catch (SECSException sECSException) {
                    return null;
                }
                if (n != 8 && n <= 64) break block29;
                int n3 = arrayList.size();
                switch (n) {
                    case 8: {
                        byteArray = new Byte[n3];
                        for (int i = 0; i < n3; ++i) {
                            byteArray[i] = (Byte)arrayList.get(i);
                        }
                        numberArray = byteArray;
                        break block30;
                    }
                    case 90: {
                        Short[] shortArray = new Short[n3];
                        for (int i = 0; i < n3; ++i) {
                            shortArray[i] = (Short)arrayList.get(i);
                        }
                        numberArray = shortArray;
                        break block30;
                    }
                    case 92: {
                        Integer[] integerArray = new Integer[n3];
                        for (int i = 0; i < n3; ++i) {
                            integerArray[i] = (Integer)arrayList.get(i);
                        }
                        numberArray = integerArray;
                        break block30;
                    }
                    case 88: {
                        Long[] longArray = new Long[n3];
                        for (int i = 0; i < n3; ++i) {
                            longArray[i] = (Long)arrayList.get(i);
                        }
                        numberArray = longArray;
                        break block30;
                    }
                    case 100: {
                        Float[] floatArray = new Float[n3];
                        for (int i = 0; i < n3; ++i) {
                            floatArray[i] = (Float)arrayList.get(i);
                        }
                        numberArray = floatArray;
                        break block30;
                    }
                    case 96: {
                        Double[] doubleArray = new Double[n3];
                        for (int i = 0; i < n3; ++i) {
                            doubleArray[i] = (Double)arrayList.get(i);
                        }
                        numberArray = doubleArray;
                        break block30;
                    }
                    case 89: {
                        Int1[] int1Array = new Int1[n3];
                        for (int i = 0; i < n3; ++i) {
                            int1Array[i] = (Int1)arrayList.get(i);
                        }
                        numberArray = int1Array;
                        break block30;
                    }
                    case 105: {
                        UInt1[] uInt1Array = new UInt1[n3];
                        for (int i = 0; i < n3; ++i) {
                            uInt1Array[i] = (UInt1)arrayList.get(i);
                        }
                        numberArray = uInt1Array;
                        break block30;
                    }
                    case 106: {
                        UShort[] uShortArray = new UShort[n3];
                        for (int i = 0; i < n3; ++i) {
                            uShortArray[i] = (UShort)arrayList.get(i);
                        }
                        numberArray = uShortArray;
                        break block30;
                    }
                    case 108: {
                        UInteger[] uIntegerArray = new UInteger[n3];
                        for (int i = 0; i < n3; ++i) {
                            uIntegerArray[i] = (UInteger)arrayList.get(i);
                        }
                        numberArray = uIntegerArray;
                        break block30;
                    }
                    case 104: {
                        ULong[] uLongArray = new ULong[n3];
                        for (int i = 0; i < n3; ++i) {
                            uLongArray[i] = (ULong)arrayList.get(i);
                        }
                        numberArray = uLongArray;
                        break block30;
                    }
                    default: {
                        throw new SECSException("Not support format." + n2);
                    }
                }
            }
            numberArray = (Number[])arrayList.get(0);
        }
        return numberArray;
    }

    public static Object convertValueOf(int n, String string) throws SECSException {
        int n2 = n & 0xFFFFFFBF;
        Object object = null;
        try {
            switch (n2) {
                case 8: {
                    byte by = Integer.decode(string).byteValue();
                    object = new Byte(by);
                    break;
                }
                case 9: {
                    object = Boolean.valueOf(string);
                    break;
                }
                case 16: {
                    object = string;
                    break;
                }
                case 17: {
                    object = Jis.decode(string);
                    break;
                }
                case 18: {
                    object = Unicode.decode(string);
                    break;
                }
                case 25: {
                    object = Int1.decode(string);
                    break;
                }
                case 26: {
                    object = Short.decode(string);
                    break;
                }
                case 28: {
                    object = Integer.decode(string);
                    break;
                }
                case 24: {
                    object = Long.decode(string);
                    break;
                }
                case 41: {
                    object = UInt1.decode(string);
                    break;
                }
                case 42: {
                    object = UShort.decode(string);
                    break;
                }
                case 44: {
                    object = UInteger.decode(string);
                    break;
                }
                case 40: {
                    object = ULong.decode(string);
                    break;
                }
                case 36: {
                    object = Float.valueOf(string);
                    break;
                }
                case 32: {
                    object = Double.valueOf(string);
                    break;
                }
                default: {
                    throw new SECSException("Not support format(" + n2 + ") and token:" + string);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SECSException("Can't Encoding");
        }
        return object;
    }

    public static String hexdump(String string, Object object) {
        String string2 = "";
        if (object == null) {
            return string2;
        }
        if (object instanceof Byte[]) {
            Byte[] byteArray = (Byte[])object;
            if (byteArray.length == 0) {
                return string2;
            }
            if (byteArray.length == 1) {
                return hexTable[byteArray[0] & 0xFF];
            }
            string2 = "\n" + string + "  " + hexTable[byteArray[0] & 0xFF] + " ";
            for (int i = 1; i < byteArray.length; ++i) {
                if (i % 8 == 0) {
                    string2 = string2 + " \n";
                    string2 = string2 + string + "  ";
                }
                string2 = string2 + hexTable[byteArray[i] & 0xFF];
                string2 = string2 + " ";
            }
            string2 = string2 + "\n";
            string2 = string2 + string;
        } else if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            int n = arrayList.size();
            if (n == 0) {
                return string2;
            }
            string2 = "\n" + string + "  " + arrayList.get(0).toString() + " ";
            for (int i = 1; i < n; ++i) {
                if (i % 4 != 0) continue;
                string2 = string2 + " \n";
                string2 = string2 + string + "  ";
            }
            string2 = string2 + "\n";
            string2 = string2 + string;
        } else {
            System.out.println("Illegal data type : Not Byte Array");
            string2 = string + object.toString();
        }
        return string2;
    }
}

