/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.jsunit.gui;

import com.jyugem.jsunit.gui.SECSMessageModel;
import com.jyugem.secs.SECSItem;
import com.jyugem.secs.SECSList;
import com.jyugem.secs.SECSMessage;
import com.sun.JTreeTable.JTreeTable;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.AbstractTableModel;

public class SECSTreeTable
extends JPanel {
    protected SECSMessageModel model;
    protected JTreeTable treeTable;
    protected JFrame frame;
    protected int reloadRow;
    JScrollPane scrollPane = null;

    public SECSTreeTable() {
    }

    public SECSTreeTable(SECSMessageModel sECSMessageModel) {
        this.model = sECSMessageModel;
        this.frame = this.createFrame();
        Container container = this.frame.getContentPane();
        JMenuBar jMenuBar = this.createMenuBar();
        this.treeTable = this.createTreeTable();
        container.add(new JScrollPane(this.treeTable));
        this.frame.setJMenuBar(jMenuBar);
        this.frame.pack();
        this.frame.show();
    }

    public void init(JPanel jPanel, SECSMessageModel sECSMessageModel) {
        this.model = sECSMessageModel;
        this.treeTable = this.createTreeTable();
        this.scrollPane = new JScrollPane(this.treeTable);
        jPanel.add(this.scrollPane);
        this.scrollPane.setBounds(new Rectangle(160, 5, 460, 390));
    }

    public void fini(JPanel jPanel) {
        if (this.scrollPane != null) {
            jPanel.remove(this.scrollPane);
        }
    }

    protected JTreeTable createTreeTable() {
        JTreeTable jTreeTable = new JTreeTable(this.model);
        Reloader reloader = new Reloader();
        jTreeTable.getTree().addTreeExpansionListener(reloader);
        return jTreeTable;
    }

    protected JFrame createFrame() {
        JFrame jFrame = new JFrame("SECS message table");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        return jFrame;
    }

    protected JMenuBar createMenuBar() {
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu2 = new JMenu("Options");
        jMenuBar.add(jMenu2);
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(lookAndFeelInfoArray[i].getName());
            jMenu2.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals(lookAndFeelInfoArray[i].getName()));
            jRadioButtonMenuItem.putClientProperty("UIKey", lookAndFeelInfoArray[i]);
            jRadioButtonMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
                    if (jRadioButtonMenuItem.isSelected()) {
                        UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)jRadioButtonMenuItem.getClientProperty("UIKey");
                        try {
                            UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                            SwingUtilities.updateComponentTreeUI(SECSTreeTable.this.frame);
                        }
                        catch (Exception exception) {
                            System.err.println("unable to set UI " + exception.getMessage());
                        }
                    }
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
        }
        return jMenuBar;
    }

    public static void main(String[] stringArray) {
        try {
            SECSMessage sECSMessage = new SECSMessage("S1F14");
            SECSItem sECSItem = new SECSItem("MDLN", "JYUGEM");
            SECSItem sECSItem2 = new SECSItem("SOFTREV", "1.0.0");
            SECSList sECSList = new SECSList();
            sECSList.add(sECSItem);
            sECSList.add(sECSItem2);
            SECSList sECSList2 = new SECSList();
            byte by = 0;
            SECSItem sECSItem3 = new SECSItem("COMMACK", by);
            sECSList2.add(sECSItem3);
            sECSList2.add(sECSList);
            sECSMessage.set(sECSList2);
            SECSMessageModel sECSMessageModel = new SECSMessageModel(sECSMessage);
            SECSTreeTable sECSTreeTable = new SECSTreeTable(sECSMessageModel);
        }
        catch (SecurityException securityException) {
            System.out.println("Could not determine home directory");
        }
    }

    class Reloader
    implements ActionListener,
    TreeExpansionListener {
        Reloader() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SECSTreeTable.this.reloadRow != -1) {
                this.generateChangeEvent(SECSTreeTable.this.reloadRow);
            }
            SECSTreeTable.this.reloadRow = -1;
        }

        protected void generateChangeEvent(int n) {
            if (n != -1) {
                AbstractTableModel abstractTableModel = (AbstractTableModel)SECSTreeTable.this.treeTable.getModel();
                abstractTableModel.fireTableChanged(new TableModelEvent(abstractTableModel, n, n, 1));
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }
    }
}

