// $Id: SECSDriver.cpp,v 1.14 2004/08/14 14:48:43 fukasawa Exp $

//=============================================================================
/**
 *  @file    SECSDriver.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================


#define BEE_BUILD_DLL

#include "com_jyugem_secs_SECSDriver.h"
#include "BS2JavaDevice.h"
#include "JSMessage.h"
#ifdef WIN32
#include "ace/WIn32_Proactor.h"
#endif

// Function prototypes
static DeviceParameter * getDeviceParameter(JNIEnv * jenv, jclass clazz,
                                            jobject parm);
//
// Worker thread for event_loop()
//
class Worker : public ACE_Task <ACE_NULL_SYNCH>
{
public:
    // Thread fuction.
    int svc(void)
    {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT("(%t) Worker in JYUSECS started\n")));

        ACE_Proactor::run_event_loop();

        ACE_DEBUG ((LM_DEBUG, "(%t) JYUSECS work complete\n"));
        return 0;
    }
};

static Worker * worker = NULL;

//
// Data
//
static bool _opened = false;
static bool _initxml = false;

// Initial ACE_Object
ACE_Object_Manager ace_object_manager;

/*
 * Class:     com_jyugem_secs_SECSDriver
 * Method:    nativeOpen
 * Signature: (Lcom/jyugem/secs/SECSDriver$Parm;)I
 */
JNIEXPORT jint JNICALL Java_com_jyugem_secs_SECSDriver_nativeOpen
  (JNIEnv * jenv, jclass clazz, jobject parm)
{
    if (_initxml == false)
    {
#if 1    // Debug log messages output to console.
//#ifdef _DEBUG
        if (ACE_LOG_MSG->open(_TX("JYUSECS"), ACE_Log_Msg::LOGGER,
                              ACE_DEFAULT_LOGGER_KEY) == -1)
        {
            _tprintf(_TX("!? Not opend Log server.\n"));
        }
        ACE_LOG_MSG->set_flags(ACE_Log_Msg::VERBOSE_LITE);
        ACE_Trace::stop_tracing();   // disable trace
#endif

        _tprintf(_TX("*** JYUSECS (Rel-1.1.8) ********\n"));
        _tprintf(_TX("Copyright(C) 2001-2004  BEE Co.,Ltd.\n"));
        _tprintf(_TX("fukasawa_mitsuo@nifty.com\n"));
        _tprintf(_TX("http://homepage2.nifty.com/SECS\n"));
        _tprintf(_TX("********************************\n"));

        b_setTraceLevel(TRL_MIDDLE);

        _initxml = true;
    }

    DeviceParameter * dev_parm = getDeviceParameter(jenv, clazz, parm);
    if (dev_parm == NULL)
    {
        return -1;
    }

    if (_opened == false)
    {
        BS2JavaDevice * jdevice = BS2JavaDevice::instance();
        jdevice->init(jenv);

        if (jdevice->open(dev_parm) < 0)
        {
            ACE_ERROR((LM_ERROR,
                       ACE_TEXT("JYUSECS : Don't initialize SECS device.\n")));
        }
#ifdef WIN32
        ACE_WIN32_Proactor * win32_proactor = new ACE_WIN32_Proactor(0, 1);
        ACE_Proactor * proactor = new ACE_Proactor(win32_proactor, 0, 0);
        ACE_Proactor::instance(proactor);
#else
        ACE_Proactor::instance();
#endif
        worker = new Worker();
        if (worker->activate(THR_NEW_LWP | THR_DETACHED) == -1)
        {
            ACE_ERROR((LM_ERROR, ACE_TEXT("%p.\n"), ACE_TEXT("JYUSECS")));
        }

        ACE_Time_Value dtv(1);
        ACE_OS::sleep(dtv);
        delete dev_parm;
        _opened = true;
    }
    else
    {
        ACE_ERROR((LM_ERROR,
                  ACE_TEXT("JYUSECS : Duplicate open device.\n")));
        return -1;
    }
    return 0;
}

/*
 * Class:     com_jyugem_secs_SECSDriver
 * Method:    nativeSend
 * Signature: (Lcom/jyugem/secs/SECSMessage;)I
 */
JNIEXPORT jint JNICALL Java_com_jyugem_secs_SECSDriver_nativeSend
  (JNIEnv * jenv, jclass clazz, jobject msgObj)
{
    ACE_UNUSED_ARG(clazz);

    if (_opened == false)
    {
        ACE_ERROR((LM_ERROR, ACE_TEXT("JYUSECS : Not opened.\n")));
        return -1;
    }

    // If initialization of setting enviroument is not just before parsing
    // object, it is bad.
    BS2JavaDevice * jdevice = BS2JavaDevice::instance();
    jdevice->init(jenv);
    BS2Message * msg = JSMessage::instance()->toMessage(msgObj);
    if (msg == NULL)
    {
        ACE_ERROR((LM_ERROR, ACE_TEXT("JYUSECS : Illegal message format.\n")));
        return -1;
    }

    // Send secs message.
    if (jdevice->send(msg) < 0)
    {
        ACE_ERROR((LM_ERROR, ACE_TEXT("JYUSECS : Send error.\n")));
        delete msg;
        return -1;
    }

    delete msg;
    return 0;
}

/*
 * Class:     com_jyugem_secs_SECSDriver
 * Method:    nativeReceive
 * Signature: ()Lcom/jyugem/secs/SECSMessage;
 */
JNIEXPORT jobject JNICALL Java_com_jyugem_secs_SECSDriver_nativeReceive
  (JNIEnv * jenv, jclass clazz)
{
    ACE_UNUSED_ARG(clazz);

    if (_opened == false)
    {
        ACE_ERROR((LM_ERROR, ACE_TEXT("JYUSECS : Not opened.\n")));
        return NULL;
    }
    // set java enviroument
    BS2JavaDevice * jdevice = BS2JavaDevice::instance();
    BS2Message * msg = jdevice->receive();
    if (msg == NULL)
    {
        // jclass newExceptionCls;
        // newExceptionCls = jenv->FindClass("java/lang/IllegalArgumentException");
        // if (newExceptionCls == 0) {
        //     return NULL;
        // }
        // jenv->ThrowNew(newExceptionCls, "SECS2 Message receive error.\n");
        ACE_ERROR((LM_ERROR, ACE_TEXT("JYUSECS : Message receive error.\n")));
        return NULL;
    }

    // If initialization of setting enviroument is not just before parsing message, it is bad.
    jdevice->init(jenv);
    jobject rcvmsg = JSMessage::instance()->toItemObj(msg);
    delete msg;
    return rcvmsg;
}

/*
 * Class:     com_jyugem_secs_SECSDriver
 * Method:    nativeClose
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_com_jyugem_secs_SECSDriver_nativeClose
  (JNIEnv * jenv, jclass clazz)
{
    ACE_UNUSED_ARG(clazz);

    if (_opened == false)
    {
        ACE_ERROR((LM_ERROR, ACE_TEXT("JYUSECS : Not opened.\n")));
        return -1;
    }
    BS2JavaDevice * device = BS2JavaDevice::instance();
    device->init(jenv);

    device->stopLoop();    // stop receive command

    ACE_OS::sleep(1);

    device->close();
    _opened = false;
    return 0;
}

//------------------------------------------------------------------------------
//
// Static functions
//
//------------------------------------------------------------------------------
//static char * _socket_param = CLASSPATH "SECSDriver$SocketParm";
static char * _serial_param = CLASSPATH "SECSDriver$CommParm";
//------------------------------------------------------------------------------
// Get parameter of communication device
//------------------------------------------------------------------------------
DeviceParameter * getDeviceParameter(JNIEnv * jenv, jclass clazz,
                                     jobject parm)
{
    TRACE_FUNCTION(TRL_LOW, "getDeviceParameter");

    ACE_UNUSED_ARG(clazz);

    DeviceParameter * dev_parm;
    jclass   parmClass;
    jfieldID fld;
    int      iotype;

    //jclass hsmsClass = jenv->FindClass(_socket_param);
    jclass secsClass = jenv->FindClass(_serial_param);
    iotype = (jenv->IsInstanceOf(parm, secsClass)) ? DRIVER_SERIAL :
                                                     DRIVER_SOCKET ;
    if ((parmClass = jenv->GetObjectClass(parm)) == NULL)
    {
        TRACE_ERROR(("Device parameter class is not found.\n"));
        return NULL;
    }

    // Get XML file
    fld = jenv->GetFieldID(parmClass, "m_xml", "Ljava/lang/String;");
    if (fld == NULL)
    {
        TRACE_ERROR((_TX("Field(m_xml) is not found found.\n")));
        return NULL;
    }
    jstring jxml = reinterpret_cast<jstring>(jenv->GetObjectField(parm, fld));
    jboolean isCopy;
    const char * xmlstr = jenv->GetStringUTFChars(jxml, &isCopy);
    string xmlName;
    if (xmlstr == NULL)
    {
        xmlName = "secs.xml";
    }
    else
    {
        xmlName = xmlstr;
    }
    if (isCopy == JNI_TRUE)
    {
        jenv->ReleaseStringUTFChars(jxml, xmlstr);
    }

    // Get Device ID
    fld = jenv->GetFieldID(parmClass, "m_devid", "I");
    if (fld == NULL)
    {
        TRACE_ERROR((_TX("Field(m_devid) is not found found.\n")));
        return NULL;
    }
    jint devid = jenv->GetIntField(parm, fld);

    // Get Host/Equipment (slave/master)
    fld = jenv->GetFieldID(parmClass, "m_isEquipment", "Z");
    if (fld == NULL)
    {
        TRACE_ERROR((_TX("Field(m_isEquipment) is not found found.\n")));
        return NULL;
    }
    jboolean equipment = jenv->GetBooleanField(parm, fld);

    if (iotype == DRIVER_SERIAL)
    {   // Create for SECS
        CommParameter * comm_parm = new CommParameter;
        comm_parm->m_deviceId = devid;
        comm_parm->m_sourceId = 0;
        comm_parm->m_slave = (equipment) ? 0 : 1;

        // Get communication port number
        fld = jenv->GetFieldID(parmClass, "m_port", "I");
        if (fld == NULL)
        {
            TRACE_ERROR((_TX("Field(m_port) is not found found.\n")));
            return NULL;
        }
        int commPort = jenv->GetIntField(parm, fld);
        sprintf(comm_parm->m_port, "COM%d", commPort);

        // Get baudrate
        fld = jenv->GetFieldID(parmClass, "m_baudrate", "I");
        if (fld == NULL)
        {
            TRACE_ERROR((_TX("Field(m_baudrate) is not found found.\n")));
            return NULL;
        }
        comm_parm->m_baudrate = jenv->GetIntField(parm, fld);

        comm_parm->m_t2timeout = 100 * 100;   // 100*100msec
        comm_parm->m_t3timeout = 45 * 1000;
        comm_parm->m_t4timeout = 45 * 1000;
        strcpy(comm_parm->m_parity, "none");
        comm_parm->m_databit = 8;
        comm_parm->m_stopbit = 1;
        comm_parm->m_read_timeout = 30;
        dev_parm = comm_parm;
    }
    else
    {   // Create for HSMS
        SocketParameter * socket_parm = new SocketParameter;
        socket_parm->m_slave = (equipment) ? 0 : 1;
        socket_parm->m_deviceId = devid;
        socket_parm->m_mode = (socket_parm->m_slave == 1) ? 0 : 1;

        // Get Device ID
        fld = jenv->GetFieldID(parmClass, "m_mode", "I");
        if (fld == NULL)
        {
            TRACE_ERROR((_TX("Field(m_mode) is not found found.\n")));
        }
        else
        {
            jint conn_mode = jenv->GetIntField(parm, fld);
            socket_parm->m_mode = (conn_mode != 0) ? 1 : 0;
        }

        // Get port number
        fld = jenv->GetFieldID(parmClass, "m_port", "I");
        if (fld == NULL)
        {
            TRACE_ERROR((_TX("Field(m_port) is not found found.\n")));
            return NULL;
        }
        socket_parm->m_port = jenv->GetIntField(parm, fld);

        // Get ip address
        fld = jenv->GetFieldID(parmClass, "m_ip", "Ljava/lang/String;");
        if (fld == NULL)
        {
            TRACE_ERROR((_TX("Field(m_ip) is not found found.\n")));
            return NULL;
        }
        jstring ip_addr = reinterpret_cast<jstring>
                              (jenv->GetObjectField(parm, fld));
        const char * ipstr = jenv->GetStringUTFChars(ip_addr, &isCopy);
        strncpy(socket_parm->m_hostname, ipstr,
                sizeof(socket_parm->m_hostname) - 1);
        socket_parm->m_hostname[sizeof(socket_parm->m_hostname) - 1] = '\0';
        if (isCopy == JNI_TRUE)
        {
            jenv->ReleaseStringUTFChars(ip_addr, ipstr);
        }

        socket_parm->m_sourceId = 0;
        socket_parm->m_t3timeout = 45 * 1000;
        socket_parm->m_t5timeout = 10 * 1000;
        socket_parm->m_t6timeout = 5 * 1000;
        socket_parm->m_t7timeout = 10 * 1000;
        socket_parm->m_t8timeout = 5 * 1000;
        socket_parm->m_hbtimeout = 0;
        dev_parm = socket_parm;
    }
    return dev_parm;
}

