// $Id: JSJis.cpp,v 1.1 2004/08/14 14:55:17 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSJis.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "BS2List.h"
#include "JSJis.h"
#include "BS2Jis.h"

static const char * _className = CLASSPATH "Jis";

void JSJis::init(JNIEnv * jenv, jclass itemClass)
{
    TRACE_FUNCTION(TRL_LOW, "JSJis::init");

    initClass(jenv, itemClass);

    m_class = jenv->FindClass(_className);
    ASSERT_JCLASS(m_class, _className);

    m_vget = m_jenv->GetMethodID(m_class, "getBytes", "()[B");
    ASSERT_METHODID(m_vget, "getBytes", "()[B");

    m_new = jenv->GetMethodID(m_class, "<init>", "([B)V");
    ASSERT_METHODID(m_new, "<init>", "([B)V");

    string argStr = "(Ljava/lang/String;L";
    argStr += _className;
    argStr += ";)V";
    m_item = m_jenv->GetMethodID(itemClass, "<init>", argStr.c_str());
    ASSERT_METHODID(m_item, "<init>", argStr.c_str());
}

// secs value to atom object
jobject JSJis::toObj(BS2Atom * atom)
{
    TRACE_FUNCTION(TRL_LOW, "JSJis::toObj");
    BS2Jis * jis = reinterpret_cast<BS2Jis *>(atom);
    jbyteArray bytes = m_jenv->NewByteArray(jis->value().size());
    m_jenv->SetByteArrayRegion(bytes, 0, jis->value().size(),
                               (jbyte *)jis->value().c_str());
    jobject obj = m_jenv->NewObject(m_class, m_new, bytes);
    return obj;
}

// secs value to item object
jobject JSJis::toItemObj(BS2Atom * atom, jstring itemName)
{
    TRACE_FUNCTION(TRL_LOW, "JSJis::toItemObj");

    BS2Jis * jis = reinterpret_cast<BS2Jis *>(atom);
    jbyteArray bytes = m_jenv->NewByteArray(jis->value().size());
    m_jenv->SetByteArrayRegion(bytes, 0, jis->value().size(),
                               (jbyte *)jis->value().c_str());
    return m_jenv->NewObject(m_itemClass, m_item, itemName, bytes);
}

// jobject to secs value
BS2Atom * JSJis::toAtom(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSJis::toAtom");
    BS2Atom * atom;

    if (valObj != NULL)
    {
        jbyteArray bytes =
            reinterpret_cast<jbyteArray>(m_jenv->CallObjectMethod(valObj, m_vget));
        jboolean isCopy0;
        jbyte * bin = m_jenv->GetByteArrayElements(bytes, &isCopy0);
        atom = new BS2Jis((BYTE *)bin, m_jenv->GetArrayLength(bytes));
        if (isCopy0 == JNI_TRUE)
        {
            m_jenv->ReleaseByteArrayElements(bytes, bin, JNI_ABORT);
        }
    }
    else
    {
        atom = new BS2Jis();
    }
    return atom;
}

// jobject to secs list
int JSJis::toList(jobject valObj, BS2List * listAtom)
{
    TRACE_FUNCTION(TRL_LOW, "JSJis::toList");

    jint len = m_jenv->CallIntMethod(valObj, m_listSize);
    for (int i = 0; i < len; i++)
    {
        jobject mbrObj = m_jenv->CallObjectMethod(valObj, m_listGet, i);
        jbyteArray bytes =
            reinterpret_cast<jbyteArray>(m_jenv->CallObjectMethod(mbrObj, m_vget));

        jboolean isCopy;
        jbyte * bin = m_jenv->GetByteArrayElements(bytes, &isCopy);
        char * str = (char *)bin;
        BS2Atom * atom = new BS2Jis(str);
        listAtom->add(*atom);
        delete atom;
        if (isCopy == JNI_TRUE)
        {
            m_jenv->ReleaseByteArrayElements(bytes, bin, JNI_ABORT);
        }
    }
    return 0;
}
