// $Id: JSInt1.cpp,v 1.5 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSInt1.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JSInt1.h"
#include "BS2Array.h"
#include "BS2List.h"

static const char * _className = CLASSPATH "Int1";

void JSInt1::init(JNIEnv * jenv, jclass itemClass)
{
    TRACE_FUNCTION(TRL_LOW, "JSInt1::init");

    initClass(jenv, itemClass);

    m_class = m_jenv->FindClass(_className);
    ASSERT_JCLASS(m_class, _className);

    m_vget = m_jenv->GetMethodID(m_class, "byteValue", "()B");
    ASSERT_METHODID(m_vget, "byteValue", "()B");

    m_new = m_jenv->GetMethodID(m_class, "<init>", "(I)V");
    ASSERT_METHODID(m_new, "<init>", "(I)V");

    string argStr = "(Ljava/lang/String;L";
    argStr += _className;
    argStr += ";)V";
    m_item = m_jenv->GetMethodID(itemClass, "<init>", argStr.c_str());
    ASSERT_METHODID(m_item, "<init>", argStr.c_str());

    m_array= jenv->GetMethodID(itemClass, "<init>",
                                          "(Ljava/lang/String;[B)V");
    ASSERT_METHODID(m_array, "<init>", "(Ljava/lang/String;[B)V");
}

// secs value to atom object
jobject JSInt1::toObj(BS2Atom * atom)
{
    TRACE_FUNCTION(TRL_LOW, "JSInt1::toObj");
    jobject obj = m_jenv->NewObject(m_class, m_new,
                                    reinterpret_cast<BS2Int1 *>(atom)->value());
    return obj;
}

// secs value to item object
jobject JSInt1::toItemObj(BS2Atom * atom, jstring itemName)
{
    TRACE_FUNCTION(TRL_LOW, "JSInt1::toItemObj");
    jobject obj;
    int format = atom->format();
    if (format & ATOM_ARRAY)
    {
        BS2Int1Array * arrayAtom = reinterpret_cast<BS2Int1Array *>(atom);
        int    len = arrayAtom->count();
        char * values = arrayAtom->value();
        jobjectArray array = m_jenv->NewObjectArray(len, m_class, NULL);
        BEEAssert(array != NULL);
        for (int i = 0; i < len; i++)
        {
            jobject aObj = m_jenv->NewObject(m_class, m_new,
                                             (int)(*(values + i)));
            m_jenv->SetObjectArrayElement(array, i, aObj);
        }
        obj = array;
    }
    else
    {
        int     val = reinterpret_cast<BS2Int1 *>(atom)->value();
        jobject valObj = m_jenv->NewObject(m_class, m_new, val);
        obj = m_jenv->NewObject(m_itemClass, m_item, itemName, valObj);
    }
    return obj;
}

// jobject to secs value
BS2Atom * JSInt1::toAtom(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSInt1::toAtom");

    BS2Atom * atom;
    if (valObj != NULL)
    {
        jbyte val = m_jenv->CallByteMethod(valObj, m_vget);
        atom = new BS2Int1(val);
    }
    else
    {
        atom = new BS2Int1();
    }
    return atom;
}

// jobject to secs array
BS2Atom * JSInt1::toArray(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSInt1::toArray");

    if (valObj == NULL)
    {
        TRACE_ERROR(("Empty member object\n"));
        return NULL;
    }

    jobjectArray array = (jobjectArray)valObj;
    jsize        len    = m_jenv->GetArrayLength(array);
    char *       values = new char[len];
    for (int i = 0; i < len; i++)
    {
        jobject obj = m_jenv->GetObjectArrayElement(array, i);
        jbyte   val = m_jenv->CallByteMethod(obj, m_vget);
        *(values + i) = (char)val;
    }
    BS2Int1Array * atom = new BS2Int1Array();
    atom->add(values, len);
    delete[] values;

    return atom;
}

// jobject to secs list
int JSInt1::toList(jobject valObj, BS2List * listAtom)
{
    TRACE_FUNCTION(TRL_LOW, "JSInt1::toList");

    jint len = m_jenv->CallIntMethod(valObj, m_listSize);
    for (int i = 0; i < len; i++)
    {
        jobject mbrObj = m_jenv->CallObjectMethod(valObj, m_listGet, i);
        jbyte val = m_jenv->CallByteMethod(mbrObj, m_vget);
        BS2Atom * atom = new BS2Int1((char)(val & 0xFF));
        listAtom->add(*atom);
        delete atom;
    }
    return 0;
}
