/* $Id: SECSTime.java,v 1.4 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    SECSTime.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.secs;

import java.util.*;

public class SECSTime {

    static String[] str60th = { "00", "01", "02", "03", "04", "05", "06", "07",
                                "08", "09", "10", "11", "12", "13", "14", "15",
                                "16", "17", "18", "19", "20", "21", "22", "23",
                                "24", "25", "26", "27", "28", "29", "30", "31",
                                "32", "33", "34", "35", "36", "37", "38", "39",
                                "40", "41", "42", "43", "44", "45", "46", "47",
                                "48", "49", "50", "51", "52", "53", "54", "55",
                                "56", "57", "58", "59" };

    public SECSTime() { }

    public static String get() {
        Calendar cal = Calendar.getInstance();
        int year =   cal.get(Calendar.YEAR);
        int month =  cal.get(Calendar.MONTH);
        int day =    cal.get(Calendar.DAY_OF_MONTH);
        int hour =   cal.get(Calendar.HOUR_OF_DAY);
        int minute = cal.get(Calendar.MINUTE);
        int sec =    cal.get(Calendar.SECOND);
        String timeStr = Integer.toString(year) + str60th[month + 1] +
                         str60th[day] + str60th[hour] +
                         str60th[minute] + str60th[sec] + "00";
        return timeStr;
    }

    public String toTimeString() {
        Calendar cal = Calendar.getInstance();
        return cal.getTime().toString();
    }

    //
    // Test main
    //
    public static void main(String[] args) {
        SECSTime date = new SECSTime();
        System.out.println(date.get() + " : " + date.toTimeString());

    }

}
