/* $Id: SECSList.java,v 1.4 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    SECSList.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.secs;

import java.io.*;
import java.util.*;
import javax.swing.tree.*;

public class SECSList extends DefaultMutableTreeNode {

    public SECSList() {
        super();
    }

    public SECSList(SECSItem item) {
        super();
        setAllowsChildren(false);
        setUserObject(item);
    }

    public SECSList(SECSList node) {
        super();
        add(node);
    }

    // Set item data
    public void set(SECSItem item) {
        setAllowsChildren(false);
        setUserObject(item);
    }

    public void set(SECSList node) {
        add(node);
    }

    public void add(SECSItem item) {
        SECSList leafNode = new SECSList(item);
        super.add(leafNode);
    }

    public boolean isEmpty() {
        return (getChildCount() == 0);
    }

    public SECSList firstElement() {
        return (SECSList)getFirstChild();
    }

    //
    // Parse message
    //
    public int parseItem(int nest, SECSParser userParser) {
        SECSList node;
        SECSItem item;
        Object obj = getUserObject();
        if (obj != null) {
            if (obj instanceof SECSList) {
                node = (SECSList)obj;
                return node.parseItem(nest, userParser);
            } else {
                item = (SECSItem)obj;
                return item.parseItem(nest, userParser); // Item only
            }
        }
        // List
        int result = userParser.beginList(nest, getChildCount());
        Enumeration e = children();
        while (e.hasMoreElements()) {
            obj = e.nextElement();
            if (obj instanceof SECSList) {
                node = (SECSList)obj;
                if (node.getUserObject() == null) {
                    result = node.parseItem(nest, userParser);
                    if (result < 0) {
                        return result;
                    }
                } else {
                    result = node.parseItem(nest + 1, userParser);
                    if (result < 0) {
                        return result;
                    }
                }
            } else {
                item = (SECSItem)obj;
                result = item.parseItem(nest, userParser);
                if (result < 0) {
                    return result;
                }
            }
        }
        result = userParser.endList(nest);
        return result;
    }

    //
    // Dumper
    //
    public void dump(int nest) {
        SECSList node;
        SECSItem item;
        Object obj = getUserObject();
        if (obj != null) {
            if (obj instanceof SECSItem) {
                item = (SECSItem)getUserObject();
                item.dump(nest);
                return ;
            } else if (obj instanceof SECSList) {
                node = (SECSList)getUserObject();
                node.dump(nest);
                return ;
            } else {
                System.out.println("SECSList.dump() : ERROR *********" + obj.toString());
                return ;
            }
        }
        String indent = new String(new char[nest * 2]);
        System.out.println(indent + "<secs:list>");
        Enumeration e = children();
        while (e.hasMoreElements()) {
            obj = e.nextElement();
            if (obj instanceof SECSList) {
                node = (SECSList)obj;
                node.dump(nest + 1);
            } else {
                item = (SECSItem)obj;
                item.dump(nest);
            }
        }
        System.out.println(indent + "</secs:list>");
    }
}
