/* $Id: SECSConfigurator.java,v 1.5 2004/08/14 14:48:42 fukasawa Exp $ */

/**
 *  @file    SECSConfigurator.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package com.jyugem.secs;

import java.util.NoSuchElementException;
import java.util.Enumeration;
import java.util.Properties;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Hashtable;

public class SECSConfigurator {
    public static boolean m_equipment = false;

    static String  configFileName = "secs.properties";
    static String  m_secsFile;
    static String  m_msgFile;
    static String  m_protocol;
    static int     m_devid;
    static String  m_ip;
    static int     m_port;
    static int     m_baudrate;
    static int     m_mode;

    public SECSConfigurator() {}

    public void configure() {
        configure(configFileName);
    }

    public void configure(String filename) {
        Properties props = new Properties();
        try {
            FileInputStream istream = new FileInputStream(filename);
            props.load(istream);
            istream.close();
        } catch (IOException e) {
            System.out.println("Could not read configuration file [" + filename + "].");
            return;
        }
        configure(props);
    }

    public static void configure(Properties properties) {
        m_secsFile = properties.getProperty("file.secs", "secs.xml");
        m_msgFile = properties.getProperty("file.response", "gemMessage.xml");
        m_protocol = properties.getProperty("secs.protocol", "HSMS");
        String role = properties.getProperty("secs.role", "HOST");
        m_equipment = (role.equals("HOST")) ? false : true;
        String dev_id = properties.getProperty("secs.devid", "1");
        m_devid = Integer.parseInt(dev_id);
        m_ip = properties.getProperty("secs.hsms.ip", "127.0.0.1");
        String baud = properties.getProperty("secs.comm.baudrate", "9600");
        m_baudrate = Integer.parseInt(baud);

        if (m_protocol.equals("HSMS")) {
            String port = properties.getProperty("secs.hsms.port", "5000");
            m_port = Integer.parseInt(port);
        } else {
            String port = properties.getProperty("secs.comm.port", "1");
            m_port = Integer.parseInt(port);
        }
        String mode = properties.getProperty("secs.mode", "ACTIVE");
        m_mode = (mode.equals("PASSIVE")) ? 1 : 0;
    }

    // Inquire parameters
    public String  getSecsXmlFile() { return m_secsFile; }
    public String  getMessageFile() { return m_msgFile; }
    public int     getDeviceID()  { return m_devid; }
    public boolean isHSMS()       { return (m_protocol.equals("HSMS")); }
    public boolean isEquipment()  { return m_equipment; }
    public boolean isHost()       { return (! m_equipment); }
    public String  getIPAddress() { return m_ip; }
    public int     getPort()      { return m_port; }
    public int     getBaudrate()  { return m_baudrate; }
    public int     getMode()      { return m_mode; }

    public static void main(String[] args) {
        SECSConfigurator config = new SECSConfigurator();
        config.configure(configFileName);

        System.out.println("SECS Format : " + m_secsFile);
        System.out.println("Device ID : " + m_devid);
        System.out.println("Protocol : " + m_protocol);
        System.out.println("Equipment : " + m_equipment);
        System.out.println("IP Address : " + m_ip);
        System.out.println("Connect mode : " + m_mode);
    }
}
