/* $Id*/

/**
 *  @file    SECSTestManager.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.jsunit.tfw;

import java.util.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.tree.*;

import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;
import junit.textui.TestRunner;
import junit.framework.*;
import junit.runner.*;
import com.jyugem.secs.*;

public class SECSTestManager extends SECSManager {
    static SECSTestManager m_instance = null;
    static String  m_testFile = null;

    TestTarget m_testTarget;
    boolean    m_doTest;
    int        m_sec;

    public static SECSTestManager getTestManager() {
        if (m_instance == null) {
             try {
                 m_instance = new SECSTestManager();
             } catch (Exception e) {
                 e.printStackTrace();
             }
             m_instance.open();
        }
        return m_instance;
    }

    SECSTestManager() {
        super();
        // m_testFile = "testGemCase.xml";   // Application testCase sets.
        m_doTest = false;
        m_testTarget = new TestTarget();
        m_sec = 3;            // delay second when start
    }

    public void   setTestFile(String fname) { m_testFile = fname; }
    public String getTestFile()             { return m_testFile;  }

    protected int open() {
        int result = super.open();
        if (result < 0) {
            return result;
        }
        if (m_testFile != null)
            m_testTarget.open(m_testFile);
        return 0;
    }

    public TestTarget getTestTarget() { return m_testTarget; }

    public void doTest()    { m_doTest = true; }
    public void doNotTest() { m_doTest = false; }

    public void run() {
        while (true) {
            try {
                if (m_doTest) {
                    sleep((int)(m_sec * 1000));
                    responder().setDispatch(true);
                    junit.textui.TestRunner.run(m_testTarget.suite());
                    responder().setDispatch(false);
                    m_doTest = false;
                }
                sleep((int)((Math.random() % 100) * 100));
            } catch (InterruptedException e) {
                responder().setDispatch(false);
                m_doTest = false;
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        SECSTestManager manager = SECSTestManager.getTestManager();
        junit.textui.TestRunner.run(manager.getTestTarget().suite());
        manager.start();
    }
}

