/* $Id: SECSTestCase.java,v 1.4 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    SECSTestCase.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.jsunit.tfw;

import junit.framework.*;
import java.lang.reflect.*;
import org.apache.oro.text.regex.*;
import org.w3c.dom.Node;
import com.jyugem.secs.*;

/**
 * Some simple tests.
 *
 */
public abstract class SECSTestCase extends SECSTestAssert {
    protected static String m_resent;
    protected static MessageBox  m_msgbox;
    protected SECSTestManager m_manager = null;

    protected String  m_methodName;

    protected int     m_delay = -1;
    protected int     m_sleep = -1;
    protected String  m_description;
    protected TestPair m_pair;

    public SECSTestCase(String name) {
        super(name);
    }

    public static String getResentReceived() { return m_resent; }
    public void setManager(SECSTestManager mngr) {
        m_manager = mngr;
        m_msgbox = m_manager.messageBox();
        m_pair.setManager(m_manager);
    }

    protected void setUp() {

    }

    /**
     * Override to run the test and assert its state.
     * @exception Throwable if any exception is thrown
     */
    protected void runTest() throws Throwable {
        Method runMethod= null;
        try {
            // use getMethod to get all public inherited
            // methods. getDeclaredMethods returns all
            // methods of this class but excludes the
            // inherited ones.
            runMethod= getClass().getMethod(m_methodName, null);
        } catch (NoSuchMethodException e) {
            fail("Method \""+m_methodName+"\" not found");
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            fail("Method \""+m_methodName+"\" should be public");
        }

        try {
            runMethod.invoke(this, new Class[0]);
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    public String getDescription() { return m_description; }
    public void setDescription(String description) { m_description = description; }
    public void setWatchTime(int time) { m_delay = time; }
    public void setSleepTime(int time) { m_sleep = time; }
    public void newPair() {
        m_pair.init();
    }

    public abstract void addPair(String sf, Node msgNode);
    public abstract void addPair(String sf, boolean defaultMessage);
    public void setLast(String expect, int decision, int match, int pattern) {
        m_pair.setLast(expect, decision, match, pattern);
    }

    public void replyNormal(SECSMessage primary) {
        m_manager.send(primary);

        SECSMessage message = m_msgbox.get(m_delay);
        assertNull(message);                          // Timeout means no error
    }

    public Object getItemValue(SECSMessage msg, String sfname, String itemName) {
        if (! sfname.equals(msg.name())) {
            return null;
        }
        ItemGetter icart = new ItemGetter(itemName);
        msg.traverse(icart);
        Object value = icart.getValue();
        return value;
    }

    public Object getItemValue(SECSMessage msg, String sfname, String itemName, int type) {
        if (! sfname.equals(msg.name())) {
            return null;
        }
        ItemGetter icart = new ItemGetter(itemName, type);
        msg.traverse(icart);
        Object value = icart.getValue();
        return value;
    }

    public String toXmlString(boolean active) {
        String xml = "<secs:testcase name=\"" + getName() + "\" description=\"" +
                     m_description + "\"";
        if (m_delay > 0) {
            xml += " time=\"" + m_delay + "\">\n";
        } else {
            xml += ">\n";
        }
        xml += m_pair.toXmlString(active);
        xml += "</secs:testcase>";
        return xml;
    }

    public String toXmlString() {
        return toXmlString((m_methodName.indexOf("Active") > 0) ? true : false);
    }
    public String toString() {
        return getName() + " : " + m_description;
    }
}
