/* $Id: AreYouThereTest.java,v 1.4 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    AreYouThereTest.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.jsunit.tfw;

import org.w3c.dom.Node;
import junit.framework.*;
import com.jyugem.secs.*;

/**
 * Some simple tests.
 *
 */
public class AreYouThereTest extends SECSTestCase {
    String m_expectS1F1;
    String m_expectS1F2;
    String m_expectS1F2_ex;

    public AreYouThereTest(String name) {
        super(name);
    }

    protected void setUp() {
        m_expectS1F1 = "<secs:message sf=\"S1F1\" wait=\"TRUE\" transaction=\"(\\d+)\">\n" +
"</secs:message>\n";

        m_expectS1F2 = "<secs:message sf=\"S1F2\" transaction=\"\\d+\">\n" +
"  <secs:list>\n" +
"    <secs:item name=\"MDLN\" type=\"ASCII\">[a-zA-Z0-9_\\.]+</secs:item>\n" +
"    <secs:item name=\"SOFTREV\" type=\"ASCII\">[a-zA-Z0-9_\\.]+</secs:item>\n" +
"  </secs:list>\n" +
"</secs:message>\n";

    }

    public static junit.framework.Test suite() {
        /*
         * the type safe way
         *
        */
        TestSuite suite= new TestSuite("Test1");
        suite.addTest(
            new AreYouThereTest("Are you there ?") {
                 protected void runTest() { testAreYouThere(); }
            }
        );

        return suite;

        /*
         * the dynamic way
        return new TestSuite(AreYouThereTestCase.class);
         */
    }

    public void testAreYouThere() {
        SECSMessage s1f1 = new SECSMessage("S1F1");
        m_manager.send(s1f1);

        SECSMessage s1f2 = m_msgbox.get();   // *** Receive response ***
        assertNotNull(s1f2);
        assertMatch("Send S1F1, Reply S1F2", m_expectS1F2, s1f2);
    }

    public void testReceiveAreYouThere() {
        //
        // The equipment must send s1f1 message
        //
        SECSMessage s1f1 = m_msgbox.get();
        assertNotNull(s1f1);

        replyNormal(s1f1);                     // Send reply message
    }

    public void testColligionAreYouThere() {
        SECSMessage s1f1 = m_msgbox.get();
        assertNotNull(s1f1);

        SECSMessage sendS1f1 = new SECSMessage("S1F1");
        m_manager.send(sendS1f1);

        SECSMessage s1f2 = m_msgbox.get();     // reply
        assertNotNull(s1f2);
        assertMatch(m_expectS1F2, s1f2);

        replyNormal(s1f1);                     // Send reply message
    }

    public void addPair(String sf, Node msgNode) {}
    public void addPair(String sf, boolean defaultMessage) {}

}
