/* $Id: ActiveTestCase.java,v 1.4 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    ActiveTestCase.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.jsunit.tfw;

import org.w3c.dom.Node;
import junit.framework.*;
import com.jyugem.secs.*;

/**
 * SECS Active test.
 *
 */
public class ActiveTestCase extends SECSTestCase {

    public ActiveTestCase(String name) {
        super(name);
        m_pair = new ActiveTestPair();
        m_methodName = "testActive";
    }

    protected void setUp() {
    }

    public static junit.framework.Test suite() {
        TestSuite suite= new TestSuite();
        suite.addTest(
            new ActiveTestCase("ActiveTestCase") {
                 protected void runTest() { testActive(); }
            }
        );
        return suite;
    }

    public void addPair(String sf, Node msgNode) {
        m_pair.add(sf, msgNode);
    }
    public void addPair(String sf, boolean defaultMessage) {
        m_pair.add(sf, defaultMessage);
    }

    public void testActive() {
        SECSMessage msg = m_pair.getMessage();
        int result = m_manager.send(msg);
        if (result < 0)
        {
            assertTrue(false);
        }
        SECSMessage reply;
        if (m_delay > 0) {
            reply = m_msgbox.get(m_delay);   // *** Receive response ***
        } else {
            reply = m_msgbox.get();          // *** Receive response ***
        }
        assertNotNull(reply);
        assertMatch(m_description, m_pair.getExpect(), reply,
                    m_pair.getMatch());

        m_resent = reply.toXMLString();
    }

    public String toXmlString() {
        return toXmlString(true);
    }

    // Send and Expect message pair
    public class ActiveTestPair extends TestPair {
        public ActiveTestPair() {
            super();
        }
    }


}
