/* $Id: SECSFrame.java,v 1.3 2003/01/18 10:38:46 fukasawa Exp $ */

/**
 *  @file    SECSFrame.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package com.jyugem.jsunit.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import com.sun.JTreeTable.*;
import com.jyugem.secs.*;

public class SECSFrame extends JFrame implements ListSelectionListener {
    SECSManager m_secs;

    // Create the UI container
    JPanel contentPane;
    JPanel buttonPane;
    JPanel statusPane;
    DefaultListModel listModel;
    JScrollPane listScrollPane;
    JList       list;
    SECSTreeTable treeTable = new SECSTreeTable();
    JLabel statusLabel = new JLabel("Strat...."); /** Used to indicate status. */

    // Stream/Function List
    private static final String sendString = "Send";
    private JButton sendButton;
    private String  sfName;

    // create the menu bar and menu items
    JMenuBar menuBar = new JMenuBar();
    JMenu menuFile = new JMenu();
    JMenuItem menuFileExit = new JMenuItem();
    JMenu editMenu = new JMenu();
    JMenuItem addMenuItem = new JMenuItem();
    JMenuItem deleteMenuItem = new JMenuItem();


    // Construct the frame
    public SECSFrame(SECSManager mngr) {
        m_secs = mngr;
        try {
            secsInit(mngr);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }

    // Component initialization
    public void secsInit(SECSManager mngr) throws Exception  {

        // UI container
        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(null);
        this.setSize(new Dimension(640, 480));
        this.setTitle("SECS MESSAGE SEND/RECEIVE");
        this.setJMenuBar(menuBar);

        // Initializes list and creates list selection event listener
        listModel = mngr.getSFList();

        //Create the list and put it in a scroll pane
        list = new JList(listModel);
        list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        list.setSelectedIndex(0);
        list.addListSelectionListener(this);
        listScrollPane = new JScrollPane(list);

        sendButton = new JButton(sendString);
        sendButton.setActionCommand(sendString);
        sendButton.addActionListener(new SendListener());

        sfName = listModel.getElementAt(
                              list.getSelectedIndex()).toString();

        //Create a panel that uses FlowLayout (the default).
        buttonPane = new JPanel();
        buttonPane.add(sendButton);

        listScrollPane.setBounds(new Rectangle(4, 5, 150, 360));
        buttonPane.setBounds(new Rectangle(4, 365, 150, 36));
        contentPane.add(listScrollPane, null);
        contentPane.add(buttonPane, null);

        // Initializes menu items and creates event listeners
        menuFile.setText("File");
        menuFileExit.setText("Exit");
        menuFileExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                menuFileExit_actionPerformed(e);
            }
        });
        editMenu.setText("Edit");
        addMenuItem.setText("Add");
        addMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
            }
        });
        deleteMenuItem.setText("Delete");
        deleteMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
            }
        });

        // Adds components to content pane
        menuBar.add(menuFile);
        menuBar.add(editMenu);
        editMenu.add(addMenuItem);
        editMenu.add(deleteMenuItem);
        menuFile.add(menuFileExit);

        // Add Status Label
        statusLabel.setHorizontalAlignment(JLabel.RIGHT);
        statusLabel.setHorizontalTextPosition(JLabel.RIGHT);
        statusLabel.setVerticalTextPosition(JLabel.CENTER);
        statusPane = new JPanel(new BorderLayout());
        statusPane.setBounds(new Rectangle(4, 405, 620, 24));
        statusPane.setBorder(new BevelBorder(BevelBorder.LOWERED));
        statusPane.add(statusLabel, BorderLayout.WEST);
        contentPane.add(statusPane, null);

    }

    /**
     * Updates the status label based on reloadRow.
     */
    protected void updateStatusLabel() {
        statusLabel.setForeground(Color.blue);
    }


    class SendListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int index = list.getSelectedIndex();
            String name = (String)listModel.get(index);
            m_secs.send(name);
        }
    }

    // File|Exit event
    void menuFileExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() == false) {

            if (list.getSelectedIndex() == -1) {
                //No selection, disable fire button.
                sfName = "";

            } else {
                //Selection, update text field.
                String name = list.getSelectedValue().toString();
                sfName = name;
                statusLabel.setText("Select: " + sfName);
                try {
                    SECSMessage msg = m_secs.getDefaultMessages().makeMessage(name);
                    if (msg != null) {
                        SECSMessageModel msgModel = new SECSMessageModel(msg);
                        treeTable.fini(contentPane);
                        treeTable.init(contentPane, msgModel);
                    }
                } catch (SECSException se) {
                }
            }
        }
    }

}
