// $Id$

//=============================================================================
/**
 *  @file    vfei_parser.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================
#define BEE_BUILD_DLL

#ifdef _MSC_VER
#pragma warning( disable: 4355 )
#endif

#include "vfei_parser.h"
#include "jyugem/cell/host_message.h"


///////////////////////////////////////////////////////////////////////////////
using namespace std;
using namespace jyugem::cell;
using namespace boost::spirit;


struct actions; // forward

struct vfei_action
{
    vfei_action(actions& actor_) : actor(actor_) {}

    ~vfei_action()
    {
    }

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const;

    actions& actor;
};

struct cmd_action
{
    cmd_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        host_message * vfeimsg =
            host_message::factory(actor.m_manager, actor.m_cmdid);
        if (vfeimsg == null)
        {
            std::cout << "Illegal vfei command: "
                      << actor.m_id << "(" << actor.m_cmdid << ")"
                      << std::endl;
            return ;
        }
        actor.m_message = vfeimsg;
    }

    actions& actor;
};

#if 0
void cmd_action::make_cmdsf()
{
    cmd_to_sf.insert(make_pair("ABORT", "S2F49"));
    cmd_to_sf.insert(make_pair("ALARM_REPORT", "S5F1"));
    cmd_to_sf.insert(make_pair("ALARM_SETUP", "S5F3"));
    cmd_to_sf.insert(make_pair("CMD_ACK", "SxFx"));
    cmd_to_sf.insert(make_pair("DISPLAY_MSG", "S10F3"));
    cmd_to_sf.insert(make_pair("EVENT_REPORT", "S6F11"));
    cmd_to_sf.insert(make_pair("EVENT_SETUP", "S2F37"));
    cmd_to_sf.insert(make_pair("INITIALIZE", "SxFx"));
    cmd_to_sf.insert(make_pair("MACH_CMD", "S2F49"));
    cmd_to_sf.insert(make_pair("MOVE", "S2F49"));
    cmd_to_sf.insert(make_pair("PAUSE", "S2F49"));
    cmd_to_sf.insert(make_pair("RES_ACTIVATE", "S15F21"));
    cmd_to_sf.insert(make_pair("RES_DEACTIVATE", "S15F21"));
    cmd_to_sf.insert(make_pair("RES_DELETE", "S7F17"));
    cmd_to_sf.insert(make_pair("RES_LIST", "S7F19"));
    cmd_to_sf.insert(make_pair("RES_QUERY", "S7F5"));
    cmd_to_sf.insert(make_pair("RES_REQUEST", "S7F1"));
    cmd_to_sf.insert(make_pair("RES_TRANSFER", "S7F3"));
    cmd_to_sf.insert(make_pair("RESTART", "S2F49"));
    cmd_to_sf.insert(make_pair("RESUME", "S2F49"));
    cmd_to_sf.insert(make_pair("SET_PARAM", "S15F21"));
    cmd_to_sf.insert(make_pair("START", "S2F49"));
    cmd_to_sf.insert(make_pair("STATUS_LIST", "S1F11"));
    cmd_to_sf.insert(make_pair("STATUS_QUERY", "S1F3"));
    cmd_to_sf.insert(make_pair("TRACE_REPORT", "S6F1"));
    cmd_to_sf.insert(make_pair("TRACE_SETUP", "S2F23"));
}
#endif

struct cmdid_action
{
    cmdid_action(actions& actor_) : actor(actor_) {}

    template <typename NumT>
    void operator()(NumT num) const
    {
        actor.m_cmdid = num;
    }

    actions& actor;
};


struct mid_action
{
    mid_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        actor.m_message->m_devid = actor.m_id;
    }

    actions& actor;
};

struct mty_action
{
    mty_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        string mty_data(first, last);
        if (mty_data[0] == 'C')
            actor.m_message->m_wait = true;
        else // if (mty_data[0] == 'R' || mty_data[0] == 'E')
            actor.m_message->m_wait = false;
    }

    actions& actor;
};

struct tid_action
{
    tid_action(actions& actor_) : actor(actor_) {}

    template<typename NumT>
    void operator()(NumT v) const
    {
        actor.m_message->m_tid = v;
    }

    actions& actor;
};

struct objspec_action
{
    objspec_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        actor.m_message->m_objspec = actor.m_value;
    }

    actions& actor;
};

struct link_action
{
    link_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        actor.m_message->append(actor.m_itemptr);
    }

    actions& actor;
};

struct iend_action
{
    iend_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        actor.m_itemptr = actor.m_istack.top();
        actor.m_istack.pop();
    }

    actions& actor;
};

struct ibegin_action
{
    ibegin_action(actions& actor_) : actor(actor_) {}

    template <typename CharT>
    void operator()(CharT) const
    {
        any_item iptr(actor.m_id, actor.m_format, "");
        actor.m_istack.push(iptr);
    }

    actions& actor;
};

struct value_action
{
    value_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        any_item& iptr = actor.m_istack.top();
        iptr.m_value = actor.m_value;
    }

    actions& actor;
};

struct lbegin_action
{
    lbegin_action(actions& actor_) : actor(actor_) {}

    template <typename CharT>
    void operator()(CharT) const
    {
        any_item aItem(actor.m_id);
        aItem.m_value.m_q = actor.m_memberq;
        actor.m_istack.push(aItem);
    }

    actions& actor;
};

struct list_action
{
    list_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        any_item& iptr = actor.m_istack.top();
        //iptr.add(actor.m_itemptr);
    }

    actions& actor;
};

struct abegin_action
{
    abegin_action(actions& actor_) : actor(actor_) {}

    template <typename CharT>
    void operator()(CharT) const
    {
        any_item iptr(actor.m_id, actor.m_format, "");
        b_valvect valvect;
        iptr.m_value = valvect;
        iptr.m_value.m_q = actor.m_memberq;
        iptr.m_value.m_t = actor.m_format;
        actor.m_istack.push(iptr);
    }

    actions& actor;
};

struct array_action
{
    array_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        any_item& iptr = actor.m_istack.top();
        iptr.m_value.m._vec->push_back(new JGvalue(actor.m_value));
    }

    actions& actor;
};

struct format_action
{
    format_action(actions& actor_) : actor(actor_) {}

    template <typename NumT>
    void operator()(NumT num) const
    {
        actor.m_format = num;
    }

    actions& actor;
};

struct strval_action
{
    strval_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        actor.m_value.assign(first + 1, last - 1);
    }

    actions& actor;
};

struct numstr_action
{
    numstr_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        actor.m_value.assign(first + 1, last - 1);
    }

    actions& actor;
};

struct trueval_action
{
    trueval_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        actor.m_value = "true";
    }

    actions& actor;
};

struct falseval_action
{
    falseval_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        actor.m_value = "false";
    }

    actions& actor;
};

struct uintval_action
{
    uintval_action(actions& actor_) : actor(actor_) {}

    template <typename NumT>
    void operator()(NumT v) const
    {
        BCHAR buf[128];
        _stprintf(buf, "%u", v);
        actor.m_value = buf;
    }

    actions& actor;
};

struct intval_action
{
    intval_action(actions& actor_) : actor(actor_) {}

    template <typename NumT>
    void operator()(NumT v) const
    {
        BCHAR buf[128];
        _stprintf(buf, "%d", v);
        actor.m_value = buf;
    }

    actions& actor;
};

struct realval_action
{
    realval_action(actions& actor_) : actor(actor_) {}

    template <typename NumT>
    void operator()(NumT v) const
    {
        BCHAR buf[128];
        _stprintf(buf, "%e", v);
        actor.m_value = buf;
    }

    actions& actor;
};

struct indentifier_action
{
    indentifier_action(actions& actor_) : actor(actor_) {}

    template <typename IteratorT>
    void operator()(IteratorT const& first, IteratorT const& last) const
    {
        actor.m_id.assign(first, last);
    }

    actions& actor;
};

struct memberq_action
{
    memberq_action(actions& actor_) : actor(actor_) {}

    template <typename NumT>
    void operator()(NumT v) const
    {
        actor.m_memberq = v;
    }

    actions& actor;
};

struct actions
{
    actions(main_manager * vfeimngr) : m_manager(vfeimngr), m_message(NULL)
        , indentifier(*this)
        , vfei(*this)
        , cmd(*this)
        , cmdid(*this)
        , mid(*this)
        , mty(*this)
        , tid(*this)
        , objspec(*this)
        , ibegin(*this)
        , value_(*this)
        , lbegin(*this)
        , list_(*this)
        , abegin(*this)
        , array_(*this)
        , fmt(*this)
        , strval(*this)
        , numstr(*this)
        , trueval(*this)
        , falseval(*this)
        , uintval(*this)
        , intval(*this)
        , realval(*this)
        , memberq(*this)
        , link(*this)
        , iend(*this)
    {
    }

    main_manager *          m_manager;
    host_message *          m_message;
    int                     m_cmdid;
    std::string             m_id;
    std::string             m_objspec;
    int                     m_format;
    size_t                  m_memberq;
    string                  m_value;
    any_item                m_itemptr;
    stack<any_item>         m_istack;

    // functors
    vfei_action             vfei;
    cmd_action              cmd;
    cmdid_action            cmdid;
    mid_action              mid;
    mty_action              mty;
    tid_action              tid;
    objspec_action          objspec;
    ibegin_action           ibegin;
    value_action            value_;
    lbegin_action           lbegin;
    list_action             list_;
    abegin_action           abegin;
    array_action            array_;
    format_action           fmt;
    strval_action           strval;
    numstr_action           numstr;
    trueval_action          trueval;
    falseval_action         falseval;
    uintval_action          uintval;
    intval_action           intval;
    realval_action          realval;
    indentifier_action      indentifier;
    memberq_action          memberq;
    link_action             link;
    iend_action             iend;
};


template <typename IteratorT>
void vfei_action::operator()(IteratorT const& first, IteratorT const& last) const
{
    if (actor.m_manager != null)
    {
    }
}

///////////////////////////////////////////////////////////////////////////////
//
//  Parse string
//
///////////////////////////////////////////////////////////////////////////////
rcmd * parse_vfei_string(main_manager * vfeimngr, const char * cmdstr)
{
    vector<char> vec;
    std::copy(cmdstr, cmdstr + strlen(cmdstr), std::back_inserter(vec));

    //  ensure that we have enough trailing newlines to eliminate
    //  the need to check for end of file in the grammar.
    vec.push_back('\n');
    vec.push_back('\n');

    vector<char>::const_iterator first = vec.begin();
    vector<char>::const_iterator last = vec.end();

    actions actor(vfeimngr);
    vfei_grammar<actions> g(actor);

    parse_info<vector<char>::const_iterator> info = parse(first, last, g);
    if (! info.full)
    {
        cerr << "Parse failed!\n";
        for (int i = 0; i < 255; ++i)
            if (info.stop == last)
                break;
            else
                cerr << *info.stop++;
        if (actor.m_message != null)
        {
            delete actor.m_message;
        }
        return null;
    }

    if (actor.m_message != null)
    {
    }
    return actor.m_message;
}


