// $Id$

//=============================================================================
/**
 *  @file    b_varinfo.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef B_VARINFO_H
#define B_VARINFO_H

#include "b_id.h"
#include "user_def.h"


struct user_varinfo
{
    user_varinfo() {}
    user_varinfo(const user_variable * uvptr)
        : m_vid(uvptr->m_vid), m_name(uvptr->m_name), m_func(uvptr->m_func) {}
    user_varinfo(const user_varinfo& rhs)
        : m_vid(rhs.m_vid), m_name(rhs.m_name), m_func(rhs.m_func) {}
    ~user_varinfo() {}

    user_varinfo& operator=(const user_varinfo& rhs)
    {
        if (this == &rhs)
            return *this;
        m_vid = rhs.m_vid;
        m_name = rhs.m_name;
        m_func = rhs.m_func;
        return *this;
    }

    int get_value(string& itemval, int id = 0);

    b_id    m_vid;
    string  m_name;
    gvfptr  m_func;
};


//
// Get value function table
//
class BEE_Export b_varinfo
{
    friend class ACE_Singleton<b_varinfo, ACE_Null_Mutex>;

public:
    typedef map< b_id, user_varinfo *, id_less, allocator<user_varinfo *> >
        id_map;
    typedef map<string, user_varinfo *, str_less, allocator<user_varinfo *> >
        namemap;

    // Add new functor
    int add(user_variable * uvptr);

    // Find functor by name/vid
    user_varinfo * find(const char * name)
    {
        string namestr(name);
        return this->find(namestr);
    }
    user_varinfo * find(const string& name);
    user_varinfo * find(const b_id& id);

    void dump() const;

    static const BCHAR * formatToSml(int format);

protected:
    b_varinfo() {}
    ~b_varinfo() {}

protected:
    id_map  m_id_vars;
    namemap m_name_vars;

    ACE_Thread_Mutex m_lock;
};

typedef ACE_Singleton<b_varinfo, ACE_Null_Mutex> USER_Variables;

extern "C" int gem_variable_add(user_variable * varinfo);

#endif  /* B_VARINFO_H */
