#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    make_gemdb.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import sqlite, pdo
import gemdb

#
def into_sqlite(dirname, output):
    filename = dirname + os.sep + 'csvfiles' + os.sep + 'gemdb.csv'
    gemdb.load_schema(filename)

    outfile = dirname + os.sep + output + ".edb"
    cx = sqlite.connect(outfile)
    cu = cx.cursor()
    for name, table in gemdb.tables.items():
        try:
            cu.execute("drop table %s" % name)
        except sqlite.DatabaseError:
            pass
        #if table.products_ == "NOT_USE":
        #    continue
        cu.execute(table.toSql())
    cx.commit()
    cx.close()

#
def into_mysql(dirname, output):
    filename = dirname + os.sep + 'csvfiles' + os.sep + 'gemdb.csv'
    gemdb.load_schema(filename)

    db = pdo.connect("Module=MySQLdb;User=%s;Passwd=%s;DB=%s" % ("jyugem", "jyugem", output))
    for name, table in gemdb.tables.items():
        try:
            db.execute("drop table if exists %s" % name)
        except sqlite.DatabaseError:
            pass
        #if table.products_ == "NOT_USE":
        #    continue
        db.execute(table.toSql())

#
def usage():
    print("make_gemdb [-m] [-f <fimename>] [-o <outfile>]");


def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "mf:o:hv",
                                   ["help", "file=", "output=", "sqlobj="])
    except getopt.GetoptError:
        usage()
        sys.exit(2)
    dirname = os.getcwd()
    output = 'gem'
    mysql = False
    verbose = False
    for o, a in opts:
        if o == "-v":
            verbose = True
        if o in ("-f", "--file"):
            dirname = a
            # fn, ext = os.path.splitext(a)
            # output = fn + ".edb"
        if o in ("-h", "--help"):
            usage()
            sys.exit()
        if o in ("-o", "--output"):
            output = a
        if o == "-m":
            mysql = True
    # ...

    if not mysql:
        into_sqlite(dirname, output)
    else:
        into_mysql(dirname, output)
    #

if __name__ == "__main__":
    main()

