#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    g_trigger.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import csv
import sqlite, pdo

#
# G_CONFIG
#
trigger_fields = ['TRIG_ID','TRIG_TYPE','MANAGER','TRIG_NAME','VID',
                  'PRIORITY','ALGORITHM']
_insert_trigger = """
insert into g_trigger \
(TRIG_ID,TRIG_TYPE,MANAGER,TRIG_NAME,VID,PRIORITY,ALGORITHM,UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s, %s, %s, %s, %s)
"""

def ins_trigger(cn, filename):
    reader = csv.DictReader(file(filename), trigger_fields)

    cn.execute("delete from g_trigger");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['TRIG_ID']) > 0:
            cn.execute(_insert_trigger, (row['TRIG_ID'],
                                         row['TRIG_TYPE'],
                                         row['MANAGER'],
                                         row['TRIG_NAME'],
                                         row['VID'],
                                         row['PRIORITY'],
                                         row['ALGORITHM'],
                                         "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def to_sqlite(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    outfile = dirname + os.sep + output + ".edb"
    cx = sqlite.connect(outfile)
    cn = cx.cursor()
    #
    ins_trigger(cn, csvdir + os.sep + "trigger.csv")
    #
    cx.commit()
    cx.close()

#
def to_mysql(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    dsn = "Module=MySQLdb;User=%s;Passwd=%s;DB=%s" % ("jyugem", "jyugem", output)
    db = pdo.connect(dsn)
    #
    ins_trigger(db, csvdir + os.sep + "trigger.csv")
    #
    db.close()


#
def usage():
    print("g_trigger [-f <dbname>]");


def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hf:v", ["help", "file="])
    except getopt.GetoptError:
        usage()
        sys.exit(2)
    output = 'gem'
    verbose = False
    for o, a in opts:
        if o == "-v":
            verbose = True
        if o in ("-f", "--file"):
            output = a
        if o in ("-h", "--help"):
            usage()
            sys.exit()
    # ...

    dirname = os.getcwd()
    if not mysql:
        to_sqlite(output, dirname)
    else:
        to_mysql(output, dirname)

if __name__ == "__main__":
    main()

