#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    ins_recipe.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import csv
import sqlite, pdo

#
# G_RECIPE
#
recipe_fields = ['LABEL','NAME','CLASS','VERSION','BODYLENGTH','BODYCHGTIME',
                 'EDITBY','BODYFORMAT','VERIFIED','LINKED','PATH','COMMENTS']
_insert_recipe = """
insert into g_connector \
(NAME,CLASS,VERSION,BODYLENGTH,BODYCHGTIME,EDITBY,BODYFORMAT,VERIFIED,LINKED,
PATH,COMMENTS,UPD_DATE,UPD_NAME
)
values (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)
"""

def ins_recipe(cn, filename):
    reader = csv.DictReader(file(filename), recipe_fields)

    cn.execute("delete from g_recipe");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['NAME']) > 0:
            cn.execute(_insert_recipe, (row['NAME'],
                                        row['CLASS'],
                                        row['VERSION'],
                                        row['BODYLENGTH'],
                                        row['BODYCHGTIME'],
                                        row['EDITBY'],
                                        row['BODYFORMAT'],
                                        row['VERIFIED'],
                                        row['LINKED'],
                                        row['PATH'],
                                        row['COMMENTS'],
                                         "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def to_sqlite(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    outfile = dirname + os.sep + output + ".edb"
    cx = sqlite.connect(outfile)
    cn = cx.cursor()
    #
    ins_recipe(cn, csvdir + os.sep + "recipe.csv")
    #
    cx.commit()
    cx.close()

#
def to_mysql(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    dsn = "Module=MySQLdb;User=%s;Passwd=%s;DB=%s" % ("jyugem", "jyugem", output)
    db = pdo.connect(dsn)
    #
    ins_recipe(db, csvdir + os.sep + "recipe.csv")
    #
    db.close()

#
def usage():
    print("g_recipe [-f <dbname>]");


def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hf:v", ["help", "file="])
    except getopt.GetoptError:
        usage()
        sys.exit(2)
    output = 'gem.edb'
    verbose = False
    for o, a in opts:
        if o == "-v":
            verbose = True
        if o in ("-f", "--file"):
            output = a
            # fn, ext = os.path.splitext(a)
            # output = fn + ".edb"
        if o in ("-h", "--help"):
            usage()
            sys.exit()
    # ...

    dirname = os.getcwd()
    if not mysql:
        to_sqlite(output, dirname)
    else:
        to_mysql(output, dirname)

if __name__ == "__main__":
    main()

