#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    g_limits.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import csv
import sqlite, pdo

#
# G_VARIABLES
#
limits_fields = ['LIMIT_TYPE','UNITS','MAX_VAL','MIN_VAL','ENABLED',
                 'LIMIT1_LOWERDB','LIMIT1_UPPERDB','LIMIT1_ENABLED',
                 'LIMIT2_LOWERDB','LIMIT2_UPPERDB','LIMIT2_ENABLED',
                 'LIMIT3_LOWERDB','LIMIT3_UPPERDB','LIMIT3_ENABLED',
                 'LIMIT4_LOWERDB','LIMIT4_UPPERDB','LIMIT4_ENABLED',
                 'LIMIT5_LOWERDB','LIMIT5_UPPERDB','LIMIT5_ENABLED',
                 'LIMIT6_LOWERDB','LIMIT6_UPPERDB','LIMIT6_ENABLED',
                 'LIMIT7_LOWERDB','LIMIT7_UPPERDB','LIMIT7_ENABLED']

_insert_limits = """
insert into g_limits (LIMIT_TYPE,UNITS,MAX_VAL,MIN_VAL,ENABLED,\
LIMIT1_LOWERDB,LIMIT1_UPPERDB,LIMIT1_ENABLED,\
LIMIT2_LOWERDB,LIMIT2_UPPERDB,LIMIT2_ENABLED,\
LIMIT3_LOWERDB,LIMIT3_UPPERDB,LIMIT3_ENABLED,\
LIMIT4_LOWERDB,LIMIT4_UPPERDB,LIMIT4_ENABLED,\
LIMIT5_LOWERDB,LIMIT5_UPPERDB,LIMIT5_ENABLED,\
LIMIT6_LOWERDB,LIMIT6_UPPERDB,LIMIT6_ENABLED,\
LIMIT7_LOWERDB,LIMIT7_UPPERDB,LIMIT7_ENABLED,\
UPD_DATE,UPD_NAME)
values
(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, \
%s, %s, %s, %s, %s, %s, %s, %s, %s)
"""

def ins_limits(cn, filename):
    reader = csv.DictReader(file(filename), limits_fields)

    cn.execute("delete from g_limits");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['LIMIT_TYPE']) > 0:
            if len(row['ENABLED']) == 0:
                row['ENABLED'] = 'Y'
            cn.execute(_insert_limits, (row['LIMIT_TYPE'],
                                        row['UNITS'],
                                        row['MAX_VAL'],
                                        row['MIN_VAL'],
                                        row['ENABLED'],
                                        row['LIMIT1_LOWERDB'],
                                        row['LIMIT1_UPPERDB'],
                                        row['LIMIT1_ENABLED'],
                                        row['LIMIT2_LOWERDB'],
                                        row['LIMIT2_UPPERDB'],
                                        row['LIMIT2_ENABLED'],
                                        row['LIMIT3_LOWERDB'],
                                        row['LIMIT3_UPPERDB'],
                                        row['LIMIT3_ENABLED'],
                                        row['LIMIT4_LOWERDB'],
                                        row['LIMIT4_UPPERDB'],
                                        row['LIMIT4_ENABLED'],
                                        row['LIMIT5_LOWERDB'],
                                        row['LIMIT5_UPPERDB'],
                                        row['LIMIT5_ENABLED'],
                                        row['LIMIT6_LOWERDB'],
                                        row['LIMIT6_UPPERDB'],
                                        row['LIMIT6_ENABLED'],
                                        row['LIMIT7_LOWERDB'],
                                        row['LIMIT7_UPPERDB'],
                                        row['LIMIT7_ENABLED'],
                                        "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def to_sqlite(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    outfile = dirname + os.sep + output + ".edb"
    cx = sqlite.connect(outfile)
    cn = cx.cursor()
    #
    ins_limits(cn, csvdir + os.sep + "limits.csv")
    #
    cx.commit()
    cx.close()

#
def to_mysql(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    dsn = "Module=MySQLdb;User=%s;Passwd=%s;DB=%s" % ("jyugem", "jyugem", output)
    db = pdo.connect(dsn)
    #
    ins_limits(db, csvdir + os.sep + "limits.csv")
    #
    db.close()

#
def usage():
    print("g_limits [-f <dbname>]");


def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hf:v", ["help", "file="])
    except getopt.GetoptError:
        usage()
        sys.exit(2)
    output = 'gem'
    verbose = False
    for o, a in opts:
        if o == "-v":
            verbose = True
        if o in ("-f", "--file"):
            output = a
        if o in ("-h", "--help"):
            usage()
            sys.exit()
    # ...

    dirname = os.getcwd()
    if not mysql:
        to_sqlite(output, dirname)
    else:
        to_mysql(output, dirname)

if __name__ == "__main__":
    main()

