#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    create_gemdb.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================
"""
Copyright (C) 2004 BEE Co.,Ltd. All Rights Reserved.

To use, simply 'import create_gemdb'.
"""

import getopt, sys, string, os, shutil
from jyugemdb import xls2csv, gemdb, make_gemdb, g_alarm, g_config, g_variables
from jyugemdb import g_connector, g_event, g_iodevice, g_limits, g_objtype
from jyugemdb import g_rcmds, g_recipe, g_trace, g_trigger

#
# Get csv file in excel file
#
def create_gemdb(dbname):
    dirname = os.path.abspath("..") + os.sep + "database"
    xls2csv.jyugem_csv(dirname)

    target = "gem"
    make_gemdb.into_sqlite(dirname, target)

    g_alarm.to_sqlite(target, dirname)
    g_config.to_sqlite(target, dirname)
    g_connector.to_sqlite(target, dirname)
    g_event.to_sqlite(target, dirname)
    g_iodevice.to_sqlite(target, dirname)
    g_limits.to_sqlite(target, dirname)
    g_objtype.to_sqlite(target, dirname)
    g_rcmds.to_sqlite(target, dirname)
    g_recipe.to_sqlite(target, dirname)
    g_trace.to_sqlite(target, dirname)
    g_trigger.to_sqlite(target, dirname)
    g_variables.to_sqlite(target, dirname)


#
# Print usage of this script
#
def usage():
    print("create_gemdb [-d <dbname>] [-h]");


#
# Test main
#
def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hd:", ["help", "dbname="])
    except getopt.GetoptError:
        usage()
        sys.exit(2)

    dbname = "gem.edb"
    for o, a in opts:
        if o in ("-d", "--dir"):
            dbname = a
        if o in ("-h", "--help"):
            usage()
            sys.exit()
    # ...

    create_gemdb(dbname)


if __name__ == "__main__":
    main()
