// $Id: JGVariable.h,v 1.4 2003/07/27 13:27:47 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGVariable.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGVARIABLE_H
#define JGVARIABLE_H

#include "jyugem/gem/gembase.h"
#include "jyugem/gem/JGNameInfo.h"

class BS2Item;
class BS2Atom;
class JGVariable;
class JGClass;
class JGLimit;
class JGTriggerInfo;
struct user_varinfo;

//
class BEE_Export JGVariable : public JGNameInfo
{
    friend class JGInfoManager;

public:
    enum { NONE, SVID, ECID };
    enum { V=0, SV=1, ECV=2, DVVAL=3, PV=4, CS=5, CV=6 };

public:
    JGVariable() : JGNameInfo()
    {
        m_svcname = _TX("");
        m_datatype = 0;
        m_format = 0;
        m_size = 0;
        m_initval = 0;
        m_minval = 0;
        m_maxval = 0;
        m_unit = _TX("");
        m_trgid = _TX("");
        m_enabled = false;
        m_save = false;
        m_limit = NULL;
        m_hostupd = false;
        m_objtype = NULL;
        m_objname = _TX("");
        m_enumerator = NULL;
        m_uservar = NULL;
    }
    virtual ~JGVariable() {}
    JGVariable& operator=(const JGVariable& rhs);
    JGVariable& operator=(BS2Atom * atom);
    virtual void  printOn(string& buf, int mode = 0);

    JGid& vid()               { return m_id; }
    void  vid(const JGid& id) { m_id = id; }
    JGid& ecid()              { return m_auxid; }
    void  auxid(const JGid& id) { m_auxid = id; }
    int     datatype() const { return m_datatype; }
    int     format() const   { return m_format; }
    bool    enabled() const  { return m_enabled; }
    JGClass * objtype()      { return m_objtype; }
    void    objtype(JGClass * klass)  { m_objtype = klass; }
    JGid&   limitCeid() { return m_limceid; }
    JGLimit * limit()   { return m_limit; }
    void    limit(JGLimit * limit) { m_limit = limit; }
    void    enumerator(b_enumerator * en) { m_enumerator = en; }
    b_enumerator * enumerator()   { return m_enumerator; }
    const string& svcName() const { return m_svcname; }
    const string& objname() const { return m_objname; }
    const string& substance() const { return m_substance; }
    void  userptr(user_varinfo * viptr)  { m_uservar = viptr; }
    const user_varinfo * userptr() const { return m_uservar; }
    const string& trgid() const { return m_trgid; }
    void  trginfo(JGTriggerInfo * info);
    JGTriggerInfo * trginfo() const { return m_trginfo; }

    int   init();
    bool  validValue(JGvalue& val, int type = -1); // Is the value in range ?
    bool  changed();                 // get and compare the last value
    int   trigger();                 // call event action
    int   sense();
    void  refresh(JGvalue& val)
    {
        m_lastval = m_curval; m_curval = val; m_hostupd = false;
    }
    void  setInt(int val);
    void  setIntAsync(int val);
    void  setv(const JGvalue& val, bool hostupd = false);
    JGvalue& getv();
    void curval(JGvalue& val) { m_lastval = m_curval; m_curval = val; }
    JGvalue& curval()         { return m_curval; }
    JGvalue& lastval()        { return m_lastval; }
    int  inc();        // increment current value
    int  dec();        // decrement current value
    int  add(int n);
    int  sub(int n);

    BS2Atom * getAtom(void * arg = NULL);
    BS2Item * createVItem(void * arg = NULL);
    BS2Item * makeVidItem();

    BS2Item * createNameItem();                // for S1F12
    BS2Item * createEcvName();                 // for S2F30
    BS2Item * makeEcvItem();                   // for S2F15

    static BS2Item * nilNameItem(JGid& svid);  // for S1F12
    static BS2Item * nilEcvName(JGid& ecid);   // for S2F30

protected:
    void copy(const JGVariable& rhs);

protected:
    string m_svcname;
    int    m_datatype;                         // SV,ECV,DVVAL,PV
    int    m_format;                           // ATOM_XXXXX
    int    m_size;
    string m_substance;
    string m_unit;
    string m_trgid;
    JGid   m_limceid;
    bool   m_enabled;
    bool   m_save;
    MUTEX_Bool m_hostupd;

    JGid    m_auxid;
    JGvalue m_initval;
    JGvalue m_minval;
    JGvalue m_maxval;

    //
    JGLimit * m_limit;
    //BS2ids  m_ids;
    JGvalue m_curval;
    JGvalue m_lastval;
    JGClass * m_objtype;
    string  m_objname;
    string  m_limtype;
    b_enumerator * m_enumerator;
    user_varinfo * m_uservar;
    JGTriggerInfo * m_trginfo;
};

typedef map<JGid, JGVariable, id_less, allocator<JGVariable> >
        JGVariableTable;
typedef map<string, JGVariable *, str_less, allocator<JGVariable *> >
        JGVarNameTable;
typedef map<JGid, JGVariable *, id_less, allocator<JGVariable *> >
        JGVidTable;
typedef JGVariableTable::value_type  JGVarPair;
typedef JGVarNameTable::value_type   JGVarNamePair;
typedef JGVidTable::value_type       JGVidPair;
typedef list<JGVariable *>   JGVariableList;
typedef vector<JGVariable *> JGVariables;


#endif  /* JGVARIABLE_H */
