// $Id: JGTrigger.h,v 1.7 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGTrigger.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGTRIGGER_H
#define JGTRIGGER_H

#include "jyugem/gem/gembase.h"
#include "jyugem/bee/state/b_trigger.h"
#include "ace/Message_Queue.h"
#include "ace/Future.h"
#include "ace/Future_Set.h"
#include "ace/Method_Request.h"
#include "ace/Activation_Queue.h"

class JGManager;
class JGTrigger;
class JGObject;
class JGTask;

typedef ACE_Future<JGTrigger *>           JGTriggerFuture;
typedef ACE_Future_Rep<JGTrigger *>       JGTriggerRepresent;
typedef ACE_Future_Set<JGTrigger *>       JGTriggerSet;
typedef ACE_Future_Observer<JGTrigger *>  JGTriggerObserver;


//
// Object
//
class BEE_Export JGTrigger : public b_trigger
{
public:
    JGTrigger(const string& cmd) : b_trigger(cmd) {}
    JGTrigger(const string& cmd, JGObject * obj)
            : b_trigger(cmd, (b_object *)obj) {}
    JGTrigger(const string& cmd, JGObject * obj, const string& dest,
              const string& from)
            : b_trigger(cmd, (b_object *)obj, dest, from) {}
    JGTrigger(const string& cmd, const string& dest, const string& from)
            : b_trigger(cmd, dest, from) {}
    JGTrigger(const JGTrigger& rhs) : b_trigger(rhs) {}

    JGTrigger& operator=(const JGTrigger& rhs) {
            if (this == &rhs)
                return *this;
            this->copy(rhs);
            return *this;
        }
    virtual ~JGTrigger() {}

    virtual void update() {}

// member methods
protected:
    JGTrigger() : b_trigger() {}

// member variables
protected:

};


//
// Asynchronous method
//
class JGTriggerRequest : public ACE_Method_Request
{
public:
    JGTriggerRequest(JGTrigger * trigger, JGTask * task = NULL)
            : ACE_Method_Request(), m_task(task), m_trigger(trigger) {}
    virtual ~JGTriggerRequest() {
            if (m_trigger != NULL)
                delete m_trigger;
        }

    virtual int call() {
            ACE_DEBUG((LM_DEBUG,
                ACE_TEXT("JGTriggerRequest::call is not supportted.\n")));
            return 0;
        }

    void set(JGTask * task) { m_task = task; }
    JGTrigger * trigger()   { return m_trigger; }
    JGTrigger * removeTrigger()   {
            JGTrigger * trig = m_trigger;
            m_trigger = NULL;
            return trig;
        }

protected:
    JGTriggerRequest() : ACE_Method_Request(), m_task(NULL), m_trigger(NULL) {}

//
protected:
    JGTask *        m_task;
    JGTrigger *     m_trigger;
    JGTriggerFuture m_future;
};

#endif  /* JGTRIGGER_H */
